/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AgentHelper;
import hydra.BaseTaskScheduler;
import hydra.ClientMgr;
import hydra.ClientVmInfo;
import hydra.ClientVmNotFoundException;
import hydra.ClientVmRecord;
import hydra.DerbyServerHelper;
import hydra.DerbyServerMgr;
import hydra.DistributedSystemHelper;
import hydra.GemFireLocatorAgentMgr;
import hydra.GemFireLocatorAgentRecord;
import hydra.HadoopDescription;
import hydra.HadoopMgr;
import hydra.HostAgentIF;
import hydra.HostAgentMgr;
import hydra.HostAgentRecord;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraThreadGroupInfo;
import hydra.Log;
import hydra.MasterController;
import hydra.MasterProxyIF;
import hydra.NetworkHelper;
import hydra.Nuker;
import hydra.PortHelper;
import hydra.RebootHostNotFoundException;
import hydra.RebootInfo;
import hydra.RemoteTestModuleIF;
import hydra.RobinG;
import hydra.TestConfig;
import hydra.TestTaskResult;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MasterProxy
extends UnicastRemoteObject
implements MasterProxyIF {
    private static int TheLock = 0;

    @Override
    public TestConfig getTestConfig() throws RemoteException {
        return TestConfig.getInstanceFromMaster();
    }

    @Override
    public TestConfig getHostAgentTestConfig() throws RemoteException {
        return TestConfig.getHostAgentInstanceFromMaster();
    }

    @Override
    public synchronized void registerGemFireLocatorAgent(GemFireLocatorAgentRecord lar) throws RemoteException {
        GemFireLocatorAgentMgr.registerGemFireLocatorAgent(lar);
    }

    @Override
    public synchronized void recordLocator(DistributedSystemHelper.Endpoint endpoint) throws RemoteException {
        endpoint.record();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void lockToSynchronizeJavaGroupsForBug30341() throws RemoteException {
        boolean gotLock = false;
        while (!gotLock) {
            Class<MasterProxy> clazz = MasterProxy.class;
            // MONITORENTER : hydra.MasterProxy.class
            if (TheLock == 0) {
                TheLock = 1;
                gotLock = true;
                Log.getLogWriter().info("Locked the javagroups lock");
            }
            // MONITOREXIT : clazz
            MasterController.sleepForMs(250);
        }
    }

    @Override
    public void unlockToSynchronizeJavaGroupsForBug30341() throws RemoteException {
        MasterController.sleepForMs(5000);
        Log.getLogWriter().info("Unlocking the javagroups lock");
        TheLock = 0;
    }

    @Override
    public DerbyServerHelper.Endpoint getDerbyServerEndpoint() throws RemoteException {
        return DerbyServerMgr.getEndpoint();
    }

    @Override
    public synchronized void registerHostAgent(HostAgentRecord har) throws RemoteException {
        HostAgentMgr.registerHostAgent(har);
    }

    @Override
    public synchronized void reportStatMonitorError(Throwable t) throws RemoteException {
        BaseTaskScheduler.setStatMonitorError(t);
    }

    @Override
    public synchronized HostAgentIF getHostAgent(String host) throws RemoteException {
        return HostAgentMgr.getRemoteHostAgentForClient(host);
    }

    @Override
    public Integer getVmid(String host, int pid) throws RemoteException {
        return ClientMgr.getVmid(host, pid);
    }

    @Override
    public List<List<String>> getClientMapping() throws RemoteException {
        return ClientMgr.getClientMapping();
    }

    @Override
    public int getPid(int vmid) throws RemoteException {
        return ClientMgr.getPid(vmid);
    }

    @Override
    public HydraThreadGroupInfo registerClient(int vmid, int tid, RemoteTestModuleIF mod) throws RemoteException {
        return ClientMgr.registerClient(vmid, tid, mod);
    }

    @Override
    public void registerClientDisconnect(int vmid) throws RemoteException {
        ClientMgr.registerClientDisconnect(vmid);
    }

    @Override
    public Map getClientVms() throws RemoteException {
        return ClientMgr.getClientVms();
    }

    @Override
    public void reportResult(int tsid, int vmid, int tid, TestTaskResult result) throws RemoteException {
        BaseTaskScheduler.reportResult(tsid, vmid, tid, result);
    }

    @Override
    public void printClientProcessStacks() throws RemoteException {
        ClientMgr.printProcessStacks();
    }

    @Override
    public Object getGlobalNext(Long key) throws RemoteException {
        RobinG r = (RobinG)TestConfig.tab().get(key);
        if (r == null) {
            throw new HydraConfigException("No RobinG at this key");
        }
        return r.next(key);
    }

    @Override
    public boolean reservePort(String host, int port) throws RemoteException {
        return PortHelper.reservePort(host, port);
    }

    @Override
    public ClientVmInfo reserveClientVmForStop(String srcName, int srcVmid, int syncMode, int stopMode, ClientVmInfo target) throws RemoteException, ClientVmNotFoundException {
        return ClientMgr.reserveClientVmForStop(srcName, srcVmid, syncMode, stopMode, target);
    }

    @Override
    public ClientVmInfo reserveClientVmForStart(String srcName, int srcVmid, ClientVmInfo target) throws RemoteException, ClientVmNotFoundException {
        return ClientMgr.reserveClientVmForStart(srcName, srcVmid, target);
    }

    @Override
    public void stopClientVm(String srcName, int srcVmid, int actionId, String reason, int syncMode, int stopMode, int startMode, ClientVmInfo target) throws RemoteException {
        ClientMgr.stopClientVm(srcName, srcVmid, actionId, reason, syncMode, stopMode, startMode, target);
    }

    @Override
    public void startClientVm(String srcName, int srcVmid, int actionId, String reason, int syncMode, ClientVmInfo target) throws RemoteException {
        ClientMgr.startClientVm(srcName, srcVmid, actionId, reason, syncMode, target);
    }

    @Override
    public ClientVmRecord bounceUnitTestVm(int pid) throws RemoteException {
        return ClientMgr.bounceUnitTestVm(pid);
    }

    @Override
    public Vector getClientVmids() throws RemoteException {
        return ClientMgr.getClientVmids();
    }

    @Override
    public Vector getOtherClientVmids(int vmid) throws RemoteException {
        return ClientMgr.getOtherClientVmids(vmid);
    }

    @Override
    public RebootInfo reserveForReboot(String srcName, int srcVmid, String target, boolean liveOnly) throws RemoteException, RebootHostNotFoundException {
        return ClientMgr.reserveForReboot(srcName, srcVmid, target, liveOnly);
    }

    @Override
    public void reboot(String srcName, int srcVmid, int actionId, String reason, RebootInfo target) throws RemoteException {
        ClientMgr.reboot(srcName, srcVmid, actionId, reason, target);
    }

    @Override
    public void configureNetworkConnection(String source, String target, int op, int way) throws RemoteException {
        NetworkHelper.configure(source, target, op, way);
    }

    @Override
    public Map getNetworkConnectionState() throws RemoteException {
        return NetworkHelper.getState();
    }

    @Override
    public void showNetworkConnectionState() throws RemoteException {
        NetworkHelper.showState();
    }

    @Override
    public synchronized void recordAgent(AgentHelper.Endpoint endpoint) throws RemoteException {
        endpoint.record();
    }

    @Override
    public void recordPID(HostDescription hd, int pid) throws RemoteException {
        Nuker.getInstance().recordPID(hd, pid);
    }

    @Override
    public void recordPIDNoDumps(HostDescription hd, int pid) throws RemoteException {
        Nuker.getInstance().recordPIDNoDumps(hd, pid);
    }

    @Override
    public void removePID(HostDescription hd, int pid) throws RemoteException {
        Nuker.getInstance().removePID(hd, pid);
    }

    @Override
    public void removePIDNoDumps(HostDescription hd, int pid) throws RemoteException {
        Nuker.getInstance().removePIDNoDumps(hd, pid);
    }

    @Override
    public void recordHadoop(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) throws RemoteException {
        HadoopMgr.recordHadoop(hdd, nd, pid, secure);
    }

    @Override
    public void removeHadoop(HadoopDescription hdd, HadoopDescription.NodeDescription nd, int pid, boolean secure) throws RemoteException {
        HadoopMgr.removeHadoop(hdd, nd, pid, secure);
    }

    @Override
    public void recordHDFSPIDNoDumps(HostDescription hd, int pid, boolean secure) throws RemoteException {
        Nuker.getInstance().recordHDFSPIDNoDumps(hd, pid, secure);
    }

    @Override
    public void removeHDFSPIDNoDumps(HostDescription hd, int pid, boolean secure) throws RemoteException {
        Nuker.getInstance().removeHDFSPIDNoDumps(hd, pid, secure);
    }

    @Override
    public void recordRootCommand(HostDescription hd, String cmd, String dir) throws RemoteException {
        Nuker.getInstance().recordRootCommand(hd, cmd, dir);
    }

    @Override
    public void recordDir(HostDescription hd, String name, String dir) throws RemoteException {
        Nuker.getInstance().recordDir(hd, name, dir);
    }

    @Override
    public void invoke(String classname, String methodname, Class[] types, Object[] args) throws RemoteException {
        MasterController.invoke(classname, methodname, types, args);
    }
}

