/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HostAgentMgr;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.Nuker;
import hydra.Platform;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class NetworkHelper {
    protected static final int DROP = 0;
    protected static final int RESTORE = 1;
    protected static final int CLEAR = 2;
    protected static final int SHOW = 3;
    private static final int ONEWAY = 0;
    private static final int TWOWAY = 1;
    private static Map Drops;

    public static synchronized void dropConnectionOneWay(String source, String target) {
        NetworkHelper.checkArgumentsOnClient(source, target);
        Log.getLogWriter().info("Dropping network connection from " + source + " to " + target);
        NetworkHelper.configureConnection(source, target, 0, 0);
        Log.getLogWriter().info("Dropped network connection from " + source + " to " + target);
    }

    public static synchronized void dropConnectionTwoWay(String source, String target) {
        NetworkHelper.checkArgumentsOnClient(source, target);
        Log.getLogWriter().info("Dropping network connection from " + source + " to " + target + " and from " + target + " to " + source);
        NetworkHelper.configureConnection(source, target, 0, 1);
        Log.getLogWriter().info("Dropped network connection from " + source + " to " + target + " and from " + target + " to " + source);
    }

    public static synchronized void restoreConnectionOneWay(String source, String target) {
        NetworkHelper.checkArgumentsOnClient(source, target);
        Log.getLogWriter().info("Restoring network connection from " + source + " to " + target);
        NetworkHelper.configureConnection(source, target, 1, 0);
        Log.getLogWriter().info("Restored network connection from " + source + " to " + target);
    }

    public static synchronized void restoreConnectionTwoWay(String source, String target) {
        NetworkHelper.checkArgumentsOnClient(source, target);
        Log.getLogWriter().info("Restoring network connection from " + source + " to " + target + " and from " + target + " to " + source);
        NetworkHelper.configureConnection(source, target, 1, 1);
        Log.getLogWriter().info("Restored network connection from " + source + " to " + target + " and from " + target + " to " + source);
    }

    public static synchronized Map getConnectionState() {
        try {
            return RemoteTestModule.Master.getNetworkConnectionState();
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static void printConnectionState() {
        Map drops = NetworkHelper.getConnectionState();
        StringBuffer buf = new StringBuffer();
        buf.append("Currently dropped network connections: ");
        if (drops.size() == 0) {
            buf.append("none");
        } else {
            for (String source : drops.keySet()) {
                List targets = (List)drops.get(source);
                buf.append("\n" + source + " to " + targets);
            }
        }
        Log.getLogWriter().info(buf.toString());
    }

    public static void showConnectionState() {
        try {
            RemoteTestModule.Master.showNetworkConnectionState();
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private static void configureConnection(String source, String target, int op, int way) {
        try {
            RemoteTestModule.Master.configureNetworkConnection(source, target, op, way);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected static synchronized void configure(String source, String target, int op, int way) {
        NetworkHelper.checkArgumentsOnMaster(source, target);
        NetworkHelper.checkState(source, target, op);
        if (way == 1) {
            NetworkHelper.checkState(target, source, op);
        }
        NetworkHelper.configure(source, target, op);
        if (way == 1) {
            NetworkHelper.configure(target, source, op);
        }
    }

    protected static synchronized Map getState() {
        if (Drops == null) {
            Drops = new HashMap();
            NetworkHelper.generateCleanupScript();
        }
        return Drops;
    }

    protected static synchronized void showState() {
        StringBuffer buf = new StringBuffer();
        Vector hosts = TestConfig.getInstance().getPhysicalHostsIncludingHadoop();
        if (hosts == null) {
            buf.append("No hosts for which to show network connection state");
        } else {
            buf.append("Showing network connection state for ").append(hosts);
            for (String host : hosts) {
                String cmd = NetworkHelper.getNetcontrolCommand(host, null, 3);
                String result = ProcessMgr.fgexec(host, cmd, 300);
                buf.append("\n").append("HOST: ").append(host).append("\n").append(result);
            }
        }
        Log.getLogWriter().info(buf.toString());
    }

    private static void configure(String source, String target, int op) {
        String msg = "network connection from " + source + " to " + target + ": " + NetworkHelper.opToString(op);
        Log.getLogWriter().info("Configuring " + msg);
        String cmd = NetworkHelper.getNetcontrolCommand(source, target, op);
        String result = ProcessMgr.fgexec(source, cmd, 300);
        if (result.indexOf("ERROR") != -1) {
            Log.getLogWriter().severe(result);
            String s = "Error configuring " + msg;
            throw new HydraRuntimeException(s);
        }
        NetworkHelper.updateState(source, target, op);
        Log.getLogWriter().info(result);
        Log.getLogWriter().info("Configured " + msg);
    }

    private static String getNetcontrolCommand(String source, String target, int op) {
        if (HostHelper.isLocalHost(source)) {
            return Platform.getInstance().getNetcontrolCommand(target, op);
        }
        try {
            return HostAgentMgr.getHostAgent(source).getNetcontrolCommand(target, op);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + source;
            throw new HydraRuntimeException(s, e);
        }
    }

    private static void checkState(String source, String target, int op) {
        ArrayList targets = (ArrayList)NetworkHelper.getState().get(source);
        if (targets == null) {
            targets = new ArrayList();
            NetworkHelper.getState().put(source, targets);
        }
        if (op == 0) {
            if (targets.contains(target)) {
                String s = "Network connection from " + source + " to " + target + " is already dropped due to a previous \"drop\" request";
                throw new IllegalStateException(s);
            }
        } else if (op == 1) {
            if (!targets.contains(target)) {
                String s = "Network connection from " + source + " to " + target + " is not currently dropped so it cannot be restored";
                throw new IllegalStateException(s);
            }
        } else {
            String s = "Should not happen";
            throw new HydraInternalException(s);
        }
    }

    private static void updateState(String source, String target, int op) {
        List targets = (List)NetworkHelper.getState().get(source);
        if (op == 0) {
            targets.add(target);
        } else if (op == 1) {
            targets.remove(target);
            if (targets.size() == 0) {
                NetworkHelper.getState().remove(source);
            }
        } else {
            String s = "Should not happen";
            throw new HydraInternalException(s);
        }
    }

    private static void generateCleanupScript() {
        Log.getLogWriter().info("Generating network connection cleanup script");
        Vector hosts = TestConfig.getInstance().getPhysicalHostsIncludingHadoop();
        if (hosts == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(Platform.getInstance().getScriptHeader()).append(Platform.getInstance().getCommentPrefix()).append(" execute this script to restore all network connections").append(" involved in this test\n\n");
        for (String host : hosts) {
            String cmd = NetworkHelper.getNetcontrolCommand(host, null, 2);
            HostDescription hd = TestConfig.getInstance().getAnyPhysicalHostDescription(host);
            buf.append(Nuker.getInstance().wrapCommand(cmd, hd) + "\n");
        }
        String script = System.getProperty("user.dir") + File.separator + "netclean" + Platform.getInstance().getFileExtension();
        FileUtil.appendToFile(script, buf.toString());
        Platform.getInstance().setExecutePermission(script);
        Log.getLogWriter().info("Generated network connection cleanup script: " + script);
    }

    private static void checkArgumentsOnClient(String source, String target) {
        if (source == null) {
            throw new IllegalArgumentException("Source host cannot be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host cannot be null");
        }
    }

    private static void checkArgumentsOnMaster(String source, String target) {
        Vector hosts = TestConfig.getInstance().getPhysicalHostsIncludingHadoop();
        if (!hosts.contains(source)) {
            String s = "Source host not in use by this test: " + source;
            Log.getLogWriter().warning(s);
            throw new IllegalArgumentException(s);
        }
        if (!hosts.contains(target)) {
            String s = "Target host not in use by this test: " + target;
            Log.getLogWriter().warning(s);
            throw new IllegalArgumentException(s);
        }
        String localhost = HostHelper.getLocalHost();
        if (source.equals(localhost)) {
            String s = "Source host is the master host: " + source;
            Log.getLogWriter().warning(s);
            throw new IllegalArgumentException(s);
        }
        if (target.equals(localhost)) {
            String s = "Target host is the master host: " + target;
            Log.getLogWriter().warning(s);
            throw new IllegalArgumentException(s);
        }
        if (source.equals(target)) {
            String s = "Source host equals target host: " + source;
            Log.getLogWriter().warning(s);
            throw new IllegalArgumentException(s);
        }
    }

    private static String opToString(int op) {
        switch (op) {
            case 0: {
                return "DROP";
            }
            case 1: {
                return "RESTORE";
            }
            case 2: {
                return "CLEAR";
            }
            case 3: {
                return "SHOW";
            }
        }
        String s = "Unknown operation: " + op;
        throw new HydraInternalException(s);
    }
}

