/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.internal.ProcessOutputReader;
import hydra.ExceptionThread;
import hydra.HydraRuntimeException;
import hydra.ResourceOperation;
import hydra.UnixPlatform;
import hydra.WindowsPlatform;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;

public abstract class Platform {
    private static final Platform platform = System.getProperty("os.name").contains("Windows") ? new WindowsPlatform() : new UnixPlatform();
    protected static final String SSH = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no";
    private static final Random rng = new Random();
    private static final int NUM_TRIES = 100;

    protected static Platform getInstance() {
        return platform;
    }

    protected String fgexec(String command, int maxWaitSec) {
        final String cmd = command;
        Runnable op = new Runnable(){

            @Override
            public void run() {
                int exitCode;
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    throw new HydraRuntimeException("Failed to create process", e);
                }
                ProcessOutputReader reader = new ProcessOutputReader(process);
                String output = reader.getOutput();
                if (output != null) {
                    output = output.trim();
                }
                if ((exitCode = reader.getExitCode()) != 0) {
                    String s = output + "\n\nCommand failed with exit code: " + exitCode;
                    throw new HydraRuntimeException(s);
                }
                ((ExceptionThread)Thread.currentThread()).setResult(output);
            }
        };
        return (String)ResourceOperation.doOp(op, "fgexec", cmd, "", maxWaitSec * 1000, false);
    }

    protected String fgexec(String command, final String[] envp, int maxWaitSec) {
        final String cmd = command;
        Runnable op = new Runnable(){

            @Override
            public void run() {
                int exitCode;
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec(cmd, envp);
                }
                catch (IOException e) {
                    throw new HydraRuntimeException("Failed to create process", e);
                }
                ProcessOutputReader reader = new ProcessOutputReader(process);
                String output = reader.getOutput();
                if (output != null) {
                    output = output.trim();
                }
                if ((exitCode = reader.getExitCode()) != 0) {
                    String s = output + "\n\nCommand failed with exit code: " + exitCode;
                    throw new HydraRuntimeException(s);
                }
                ((ExceptionThread)Thread.currentThread()).setResult(output);
            }
        };
        return (String)ResourceOperation.doOp(op, "fgexec", cmd, "", maxWaitSec * 1000, false);
    }

    protected String fgexec(String[] command, int maxWaitSec) {
        final String[] cmd = command;
        String cmdstr = Platform.getString(command);
        Runnable op = new Runnable(){

            @Override
            public void run() {
                int exitCode;
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    throw new HydraRuntimeException("Failed to create process", e);
                }
                ProcessOutputReader reader = new ProcessOutputReader(process);
                String output = reader.getOutput();
                if (output != null) {
                    output = output.trim();
                }
                if ((exitCode = reader.getExitCode()) != 0) {
                    String s = output + "\n\nCommand failed with exit code: " + exitCode;
                    throw new HydraRuntimeException(s);
                }
                ((ExceptionThread)Thread.currentThread()).setResult(output);
            }
        };
        return (String)ResourceOperation.doOp(op, "fgexec", cmdstr, "", maxWaitSec * 1000, false);
    }

    protected static String getString(String[] s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            str.append(s[i] + " ");
        }
        return str.toString().trim();
    }

    protected int fgexec(String[] cmdArray, String[] output, File workdir) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdArray, null, workdir);
        ProcessOutputReader reader = new ProcessOutputReader(process);
        output[0] = reader.getOutput();
        return reader.getExitCode();
    }

    protected int bgexec(String command, File workdir, File logfile) throws IOException {
        String[] cmdarray = command.split(" +");
        return this.bgexec(cmdarray, workdir, logfile);
    }

    protected int bgexec(String[] cmdarray, File workdir, File logfile) throws IOException {
        int pid;
        if (workdir != null && !workdir.isDirectory()) {
            String curDir = new File("").getAbsolutePath();
            System.out.println("WARNING: \"" + workdir + "\" is not a directory. Defaulting to current directory \"" + curDir + "\".");
            workdir = null;
        }
        if (workdir == null) {
            workdir = new File("").getAbsoluteFile();
        }
        if (logfile == null) {
            logfile = this.createTempFile("bgexec", ".log", workdir);
        }
        if (!logfile.isAbsolute()) {
            logfile = new File(workdir, logfile.getPath());
        }
        if (logfile.exists()) {
            if (!logfile.isFile()) {
                throw new IOException("The log file \"" + logfile.getPath() + "\" was not a normal file.");
            }
            if (!logfile.canWrite()) {
                throw new IOException("Need write access for the log file \"" + logfile.getPath() + "\".");
            }
        } else {
            try {
                logfile.createNewFile();
            }
            catch (IOException io) {
                throw new IOException("Could not create log file \"" + logfile.getPath() + "\" because: " + io.getMessage() + ".");
            }
        }
        if ((pid = this.bgexecInternal(cmdarray, workdir.getPath(), logfile.getPath())) <= 0) {
            throw new IOException("Command failed with invalid PID: " + pid);
        }
        return pid;
    }

    private File createTempFile(String prefix, String suffix, File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("dir cannot be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("suffix cannot be null");
        }
        for (int i = 0; i < 100; ++i) {
            int id = 10000 + rng.nextInt(10000);
            String fn = dir.getAbsolutePath() + File.separator + prefix + id + suffix;
            File f = new File(fn);
            try {
                if (!f.createNewFile()) continue;
                return f;
            }
            catch (IOException io) {
                throw new IOException("Could not create temp file \"" + f.getPath() + "\" because: " + io.getMessage() + ".");
            }
        }
        throw new IOException("Could not create " + prefix + " temp file in " + dir + " in " + 100 + " tries");
    }

    protected abstract int bgexecInternal(String[] var1, String var2, String var3) throws IOException;

    protected void checkPid(int pid) {
        if (pid <= 0) {
            String s = "Should not send a signal to pid " + pid;
            throw new IllegalArgumentException(s);
        }
    }

    protected abstract boolean exists(int var1);

    protected abstract void shutdown(int var1);

    protected abstract void kill(int var1);

    protected abstract void printStacks(int var1);

    protected abstract void dumpHeap(int var1, String var2, String var3);

    protected abstract String getNetworkStatistics(int var1);

    protected abstract String getShutdownCommand(int var1);

    protected abstract String getKillCommand(int var1);

    protected abstract String getDumpLocksCommand(int var1);

    protected abstract String getPrintStacksCommand(int var1);

    protected abstract String[] getDumpHeapCommand(int var1, String var2, String var3);

    protected abstract String getNetcontrolCommand(String var1, int var2);

    protected abstract void restartNTP();

    protected abstract String getFileExtension();

    protected abstract String getScriptHeader();

    protected abstract String getCommentPrefix();

    protected abstract void setExecutePermission(String var1);

    protected abstract void setReadPermission(String var1);

    protected abstract String getProcessStatus(int var1);

    protected abstract String getMemoryStatus(int var1);

    protected String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }
}

