/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ExceptionThread;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import java.util.Vector;

public class ResourceOperation {
    public static Object doOp(Runnable op, String opname, String resourcetype, Object record, int timeoutMs, boolean verbose) {
        ExceptionThread thread = new ExceptionThread(op, opname);
        if (verbose) {
            Log.getLogWriter().info("Executing operation \"" + opname + "\" on " + resourcetype + " " + record);
        }
        thread.start();
        return ResourceOperation.joinUpWith(thread, opname, resourcetype, record, timeoutMs, verbose);
    }

    public static Object[] doOps(Vector ops, String opname, String resourcetype, Vector records, int timeoutMs, boolean concurrent, int delayMs, boolean verbose) {
        int i;
        int numOps = ops.size();
        if (numOps == 0) {
            return null;
        }
        if (numOps != records.size()) {
            throw new HydraInternalException("Number of ops (" + numOps + ") not equal to number of records (" + records.size() + ")");
        }
        ExceptionThread[] threads = new ExceptionThread[numOps];
        Object[] results = new Object[numOps];
        for (i = 0; i < numOps; ++i) {
            Runnable op = (Runnable)ops.elementAt(i);
            threads[i] = new ExceptionThread(op, opname);
            if (verbose) {
                Log.getLogWriter().info("Executing operation \"" + opname + "\" on " + resourcetype + " " + records.elementAt(i));
            }
            threads[i].start();
            if (!concurrent) {
                results[i] = ResourceOperation.joinUpWith(threads[i], opname, resourcetype, records.elementAt(i), timeoutMs, verbose);
                continue;
            }
            if (delayMs <= 0) continue;
            MasterController.sleepForMs(delayMs);
        }
        if (concurrent) {
            for (i = 0; i < numOps; ++i) {
                results[i] = ResourceOperation.joinUpWith(threads[i], opname, resourcetype, records.elementAt(i), timeoutMs, verbose);
            }
        }
        return results;
    }

    private static Object joinUpWith(ExceptionThread thread, String opname, String resourcetype, Object record, int timeoutMs, boolean verbose) {
        try {
            thread.join(timeoutMs);
        }
        catch (InterruptedException e) {
            throw new HydraRuntimeException("Interrupted during operation \"" + opname + "\" on " + resourcetype + " " + record, e);
        }
        Throwable e = thread.getException();
        if (e instanceof HydraTimeoutException) {
            String s = "Timeout exception during operation \"" + opname + "\" on " + resourcetype + " " + record;
            throw new HydraTimeoutException(s, e);
        }
        if (e != null) {
            throw new HydraRuntimeException("Exception during operation \"" + opname + "\" on " + resourcetype + " " + record, e);
        }
        if (thread.isAlive()) {
            String s = "Timed out after waiting " + timeoutMs + " milliseconds for operation \"" + opname + "\" on " + resourcetype + " " + record;
            throw new HydraTimeoutException(s, e);
        }
        if (verbose) {
            Log.getLogWriter().info("Executed operation \"" + opname + "\" on " + resourcetype + " " + record);
        }
        return thread.getResult();
    }
}

