/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientDescription;
import hydra.ClientRecord;
import hydra.DeadlockDetection;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Java;
import hydra.Log;
import hydra.MasterDescription;
import hydra.Nuker;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.TestFileUtil;
import hydra.TestTask;
import hydra.TestTaskResult;
import hydra.log.LogPrms;
import java.io.File;
import java.io.IOException;
import java.util.List;
import perffmwk.PerfReportPrms;
import util.TestHelper;

public class ResultLogger {
    private static final String ERROR_FILE = "errors.txt";
    private static final Object ERROR_FILE_LOCK = new Object();
    private static final String HANG_FILE = "hang.txt";
    private static final Object HANG_FILE_LOCK = new Object();
    private static final String divider = "--------------------------------------------------------------------------------\n";
    private static final String FAILED_FILE = "failed.txt";

    protected static void logTaskResult(TestTask task, TestTaskResult result) {
        String header = "Task result: " + task.toShortString() + ": ";
        if (result.getErrorStatus()) {
            Log.getLogWriter().severe(header + result.getErrorString());
        } else {
            Log.getLogWriter().info(header + result.getResult());
        }
    }

    protected static void logTaskResult(ClientRecord client, TestTask task, TestTaskResult result) {
        String header = "Result for " + client + ": " + task.toShortString() + ": ";
        if (result.getErrorStatus()) {
            Log.getLogWriter().severe(header + result.getErrorString());
            String err = "CLIENT " + client + "\n" + task.toShortString() + "\n" + result.getErrorString();
            ResultLogger.writeErrorFile(err);
        } else {
            Log.getLogWriter().info(header + result.getResult());
        }
    }

    protected static void logHangResult(ClientRecord client, TestTask task, TestTaskResult result) {
        String header = "Result for " + client + ": " + task.toShortString() + ": ";
        if (!result.getErrorStatus()) {
            throw new HydraInternalException("Attempt to log a hang with no error");
        }
        Log.getLogWriter().severe(header + result.getErrorString());
        String err = "CLIENT " + client + "\n" + task.toShortString() + "\n" + result.getErrorString();
        ResultLogger.writeErrorFile(err);
        ResultLogger.writeHangFile();
        DeadlockDetection.detectDeadlocks(client);
    }

    protected static void logHangResult(ClientRecord client, TestTask task, String msg) {
        String header = "Result for " + client + ": " + task.toShortString() + ": ";
        Log.getLogWriter().severe(header + "HANG " + msg);
        String err = "CLIENT " + client + "\n" + task.toShortString() + "\n" + "HANG " + msg + "\n";
        ResultLogger.writeErrorFile(err);
        ResultLogger.writeHangFile();
        DeadlockDetection.detectDeadlocks(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeErrorFile(String msg) {
        Object object = ERROR_FILE_LOCK;
        synchronized (object) {
            FileUtil.appendToFile(ERROR_FILE, msg + divider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeHangFile() {
        Object object = HANG_FILE_LOCK;
        synchronized (object) {
            if (!FileUtil.exists(HANG_FILE)) {
                FileUtil.appendToFile(HANG_FILE, "possible hang in test...processes left running...see errors.txt for more info\n");
            }
        }
    }

    protected static void reportErr(String msg, Throwable t) {
        String err = "ERROR " + msg + "\n";
        if (t != null) {
            err = err + "\n" + TestHelper.getStackTrace(t);
        }
        Log.getLogWriter().severe(err);
        err = "THREAD " + Thread.currentThread().getName() + "\n" + err;
        ResultLogger.writeErrorFile(err);
    }

    protected static void reportHang(String msg, Throwable t) {
        String err = "HANG ";
        err = msg == null && t != null ? err + t.getMessage() + "\n" + TestHelper.getStackTrace(t) : (msg != null && t == null ? err + msg + "\n" : (msg != null && t != null ? err + msg + "\n" + TestHelper.getStackTrace(t) : err + "no information available\n"));
        Log.getLogWriter().severe(err);
        err = "THREAD " + Thread.currentThread().getName() + "\n" + err;
        ResultLogger.writeErrorFile(err);
        ResultLogger.writeHangFile();
        DeadlockDetection.detectDeadlocks();
    }

    protected static void reportErr(int pid, String msg) {
        String err = "CLIENT WindowTester/GFMon VM pid=" + pid + "\n" + "ERROR " + msg;
        ResultLogger.writeErrorFile(err);
    }

    protected static void reportHang(int pid, String msg) {
        String err = "CLIENT WindowTester/GFMon VM pid=" + pid + "\n" + "HANG " + msg;
        ResultLogger.writeErrorFile(err);
        ResultLogger.writeHangFile();
        DeadlockDetection.detectDeadlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean hasErrorFile() {
        Object object = ERROR_FILE_LOCK;
        synchronized (object) {
            return FileUtil.exists(ERROR_FILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean hasHangFile() {
        Object object = HANG_FILE_LOCK;
        synchronized (object) {
            return FileUtil.exists(HANG_FILE);
        }
    }

    protected static void reportAsErr(String m, Throwable t) {
        String err = m + " -- unexpected exception";
        ResultLogger.reportErr(err, t);
    }

    protected static void reportAsHang(String msg, Throwable t) {
        ResultLogger.reportHang(msg + " -- treating as hang", t);
    }

    protected static void logFinalOutcome(String msg, boolean passed) {
        Log.getLogWriter().severe(msg);
        if (!passed) {
            try {
                FileUtil.createNewFile(FAILED_FILE);
            }
            catch (IOException e) {
                String s = "Unable to create new file failed.txt";
                throw new HydraRuntimeException(s, e);
            }
        }
    }

    protected static void generatePerformanceReportFile() {
        ClientDescription cd = new ClientDescription();
        cd.setName("perfreporter");
        MasterDescription md = TestConfig.getInstance().getMasterDescription();
        cd.setVmDescription(md.getVmDescription());
        String heap = "-Xmx" + TestConfig.tab().stringAt(PerfReportPrms.heapSize);
        String brief = "-DBrief=" + TestConfig.tab().booleanAt(PerfReportPrms.generateBriefReport, false);
        cd.getVmDescription().setExtraVMArgs(heap + " " + brief);
        int pid = Java.java(cd, "perffmwk.PerfReporter");
        Log.getLogWriter().info("Done generating performance report...see " + md.getVmDescription().getHostDescription().getUserDir() + File.separator + "perfreport.txt for the result." + " The performance report log is bgexec*_" + pid + ".log.");
        int maxWaitSec = TestConfig.tab().intAt(PerfReportPrms.maxReportWaitSec);
        HostDescription hd = cd.getVmDescription().getHostDescription();
        if (ProcessMgr.waitForDeath(hd.getHostName(), pid, maxWaitSec)) {
            Nuker.getInstance().removePID(hd, pid);
        } else {
            Log.getLogWriter().warning("Waited more than " + maxWaitSec + " seconds for performance report to complete, try increasing ");
        }
    }

    public static void mergeLogFiles(boolean passed) {
        String fn = "mergedLogs.txt";
        String value = TestConfig.tab().stringAt(LogPrms.mergeLogFiles, "false");
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("onFailure") && !passed) {
            try {
                String masterUserDir = System.getProperty("user.dir");
                List logFiles = TestFileUtil.getMergeLogFiles(masterUserDir);
                int pid = Java.javaMergeLogFiles(fn, logFiles);
                Log.getLogWriter().info("Done merging log files...see " + fn + " for the result." + " The merge process log is bgexec*_" + pid + ".log.");
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

