/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.SSLPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class SSLDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private String keyStore;
    private String keyStorePassword;
    private String sslCiphers;
    private Boolean sslEnabled;
    private String sslProtocols;
    private Boolean sslRequireAuthentication;
    private String trustStore;
    private String trustStorePassword;
    private transient Properties distributedSystemProperties;
    private transient Properties systemProperties;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private String getKeyStore() {
        return this.keyStore;
    }

    private void setKeyStore(String str) {
        this.keyStore = str;
    }

    private String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    private void setKeyStorePassword(String str) {
        this.keyStorePassword = str;
    }

    protected String getSSLCiphers() {
        return this.sslCiphers;
    }

    private void setSSLCiphers(String str) {
        this.sslCiphers = str;
    }

    protected Boolean getSSLEnabled() {
        return this.sslEnabled;
    }

    private void setSSLEnabled(Boolean bool) {
        this.sslEnabled = bool;
    }

    protected String getSSLProtocols() {
        return this.sslProtocols;
    }

    private void setSSLProtocols(String str) {
        this.sslProtocols = str;
    }

    protected Boolean getSSLRequireAuthentication() {
        return this.sslRequireAuthentication;
    }

    private void setSSLRequireAuthentication(Boolean bool) {
        this.sslRequireAuthentication = bool;
    }

    private String getTrustStore() {
        return this.trustStore;
    }

    private void setTrustStore(String str) {
        this.trustStore = str;
    }

    private String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    private void setTrustStorePassword(String str) {
        this.trustStorePassword = str;
    }

    protected synchronized Properties getSystemProperties(String mcastPort) {
        if (this.systemProperties == null) {
            Properties p = new Properties();
            String s = "gemfire.";
            p.setProperty(s + "ssl-ciphers", this.getSSLCiphers());
            p.setProperty(s + "ssl-enabled", this.getSSLEnabled().toString());
            p.setProperty(s + "ssl-protocols", this.getSSLProtocols());
            p.setProperty(s + "ssl-require-authentication", this.getSSLRequireAuthentication().toString());
            p.setProperty(s + "mcast-port", mcastPort);
            s = "javax.net.ssl.";
            p.setProperty(s + "keyStore", SSLDescription.getPath(SSLPrms.keyStore, this.getKeyStore()));
            p.setProperty(s + "keyStorePassword", this.getKeyStorePassword());
            p.setProperty(s + "trustStore", SSLDescription.getPath(SSLPrms.trustStore, this.getTrustStore()));
            p.setProperty(s + "trustStorePassword", this.getTrustStorePassword());
            this.systemProperties = p;
        }
        return this.systemProperties;
    }

    protected synchronized void setSystemProperties(String mcastPort) {
        Properties p = this.getSystemProperties(mcastPort);
        if (p != null) {
            for (String string : p.keySet()) {
                String val = p.getProperty(string);
                System.setProperty(string, val);
            }
        }
    }

    public synchronized Properties getDistributedSystemProperties() {
        if (this.distributedSystemProperties == null) {
            Properties p = new Properties();
            p.setProperty("ssl-ciphers", this.getSSLCiphers());
            p.setProperty("ssl-enabled", this.getSSLEnabled().toString());
            p.setProperty("ssl-protocols", this.getSSLProtocols());
            p.setProperty("ssl-require-authentication", this.getSSLRequireAuthentication().toString());
            this.distributedSystemProperties = p;
        }
        return this.distributedSystemProperties;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "keyStore", this.getKeyStore());
        map.put(header + "keyStorePassword", this.getKeyStorePassword());
        map.put(header + "sslCiphers", this.getSSLCiphers());
        map.put(header + "sslEnabled", this.getSSLEnabled());
        map.put(header + "sslProtocols", this.getSSLProtocols());
        map.put(header + "sslRequireAuthentication", this.getSSLRequireAuthentication());
        map.put(header + "trustStore", this.getTrustStore());
        map.put(header + "trustStorePassword", this.getTrustStorePassword());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(SSLPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            SSLDescription sd = SSLDescription.createSSLDescription(name, config, i);
            config.addSSLDescription(sd);
        }
    }

    private static SSLDescription createSSLDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        SSLDescription sd = new SSLDescription();
        sd.setName(name);
        Long key = SSLPrms.keyStore;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey(key) + " is a required field";
            throw new HydraConfigException(s);
        }
        sd.setKeyStore(str);
        key = SSLPrms.keyStorePassword;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey(key) + " is a required field";
            throw new HydraConfigException(s);
        }
        sd.setKeyStorePassword(str);
        key = SSLPrms.sslCiphers;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = "any";
        }
        sd.setSSLCiphers(str);
        key = SSLPrms.sslEnabled;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        sd.setSSLEnabled(bool);
        key = SSLPrms.sslProtocols;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = "any";
        }
        sd.setSSLProtocols(str);
        key = SSLPrms.sslRequireAuthentication;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        sd.setSSLRequireAuthentication(bool);
        key = SSLPrms.trustStore;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = sd.getKeyStore();
        }
        sd.setTrustStore(str);
        key = SSLPrms.trustStorePassword;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = sd.getKeyStorePassword();
        }
        sd.setTrustStorePassword(str);
        return sd;
    }
}

