/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.security.AccessControl;
import com.gemstone.gemfire.security.AuthInitialize;
import com.gemstone.gemfire.security.Authenticator;
import hydra.AbstractDescription;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.GemFireDescription;
import hydra.HydraVector;
import hydra.RemoteTestModule;
import hydra.SecurityPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class SecurityDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private String clientAccessor;
    private String clientAccessorPP;
    private String clientAuthInit;
    private String clientAuthenticator;
    private Map clientExtraPrms;
    private String clientExtraPrmsClass;
    private String logLevel;
    private String peerAuthInit;
    private String peerAuthenticator;
    private Map peerExtraPrms;
    private String peerExtraPrmsClass;
    private Integer peerVerifymemberTimeout;
    private transient Properties clientExtraProperties;
    private transient Properties peerExtraProperties;
    private transient Properties distributedSystemProperties;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private String getClientAccessor() {
        return this.clientAccessor;
    }

    private void setClientAccessor(String str) {
        this.clientAccessor = str;
    }

    private String getClientAccessorPP() {
        return this.clientAccessorPP;
    }

    private void setClientAccessorPP(String str) {
        this.clientAccessorPP = str;
    }

    private String getClientAuthInit() {
        return this.clientAuthInit;
    }

    private void setClientAuthInit(String str) {
        this.clientAuthInit = str;
    }

    private String getClientAuthenticator() {
        return this.clientAuthenticator;
    }

    private void setClientAuthenticator(String str) {
        this.clientAuthenticator = str;
    }

    private synchronized String getClientExtraPrmsClass() {
        return this.clientExtraPrmsClass;
    }

    private void setClientExtraPrmsClass(String str) {
        this.clientExtraPrmsClass = str;
    }

    private synchronized Map getClientExtraPrms() {
        return this.clientExtraPrms;
    }

    private void setClientExtraPrms(Map map) {
        this.clientExtraPrms = map;
    }

    private String getLogLevel() {
        return this.logLevel;
    }

    private void setLogLevel(String str) {
        this.logLevel = str;
    }

    private String getPeerAuthInit() {
        return this.peerAuthInit;
    }

    private void setPeerAuthInit(String str) {
        this.peerAuthInit = str;
    }

    private String getPeerAuthenticator() {
        return this.peerAuthenticator;
    }

    private void setPeerAuthenticator(String str) {
        this.peerAuthenticator = str;
    }

    private synchronized String getPeerExtraPrmsClass() {
        return this.peerExtraPrmsClass;
    }

    private void setPeerExtraPrmsClass(String str) {
        this.peerExtraPrmsClass = str;
    }

    private synchronized Map getPeerExtraPrms() {
        return this.peerExtraPrms;
    }

    private void setPeerExtraPrms(Map map) {
        this.peerExtraPrms = map;
    }

    private Integer getPeerVerifymemberTimeout() {
        return this.peerVerifymemberTimeout;
    }

    private void setPeerVerifymemberTimeout(Integer i) {
        this.peerVerifymemberTimeout = i;
    }

    protected String getSecurityLogFileName(GemFireDescription gfd) {
        return gfd.getSysDirName() + "/security.log";
    }

    public synchronized Properties getDistributedSystemProperties(GemFireDescription gfd) {
        if (this.distributedSystemProperties == null) {
            Properties p = new Properties();
            p.setProperty("security-client-accessor", this.getClientAccessor());
            p.setProperty("security-client-accessor-pp", this.getClientAccessorPP());
            p.setProperty("security-client-auth-init", this.getClientAuthInit());
            p.setProperty("security-client-authenticator", this.getClientAuthenticator());
            this.addProperties(this.getClientExtraProperties(), p);
            p.setProperty("security-log-file", this.getSecurityLogFileName(gfd));
            p.setProperty("security-log-level", this.getLogLevel());
            p.setProperty("security-peer-auth-init", this.getPeerAuthInit());
            p.setProperty("security-peer-authenticator", this.getPeerAuthenticator());
            p.setProperty("security-peer-verifymember-timeout", String.valueOf(this.getPeerVerifymemberTimeout()));
            this.addProperties(this.getPeerExtraProperties(), p);
            this.distributedSystemProperties = p;
        }
        return this.distributedSystemProperties;
    }

    public synchronized Properties getClientExtraProperties() {
        if (this.clientExtraProperties == null) {
            this.clientExtraProperties = this.getExtraProperties(this.clientExtraPrmsClass, this.clientExtraPrms);
        }
        return this.clientExtraProperties;
    }

    public synchronized Properties getPeerExtraProperties() {
        if (this.peerExtraProperties == null) {
            this.peerExtraProperties = this.getExtraProperties(this.peerExtraPrmsClass, this.peerExtraPrms);
        }
        return this.peerExtraProperties;
    }

    private Properties getExtraProperties(String prmclass, Map prms) {
        Properties p = null;
        if (prmclass != null && prms != null) {
            SecurityDescription.loadClass(prmclass);
            p = new Properties();
            for (Long key : prms.keySet()) {
                ConfigHashtable tasktab;
                String defaultVal = (String)prms.get(key);
                String setVal = TestConfig.tab().stringAt(key, defaultVal);
                RemoteTestModule mod = RemoteTestModule.getCurrentThread();
                if (mod != null && (tasktab = mod.getCurrentTask().getTaskAttributes()) != null) {
                    setVal = tasktab.stringAt(key, setVal);
                }
                if (setVal.startsWith("$JTESTS")) {
                    setVal = EnvHelper.expandPath(setVal);
                } else if (setVal.startsWith("$")) {
                    setVal = EnvHelper.expandEnvVars(setVal);
                }
                p.setProperty(this.convertSecurityPrm(key), setVal);
            }
        }
        return p;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "clientAccessor", this.getClientAccessor());
        map.put(header + "clientAccessorPP", this.getClientAccessorPP());
        map.put(header + "clientAuthInit", this.getClientAuthInit());
        map.put(header + "clientAuthenticator", this.getClientAuthenticator());
        if (this.clientExtraPrmsClass != null) {
            map.put(header + "clientExtraProperties", this.getClientExtraPrmsClass() + " defaults: " + this.convertSecurityPrms(this.getClientExtraPrms()));
        }
        map.put(header + "logFile", "autogenerated: security.log in system directory");
        map.put(header + "logLevel", this.getLogLevel());
        map.put(header + "peerAuthInit", this.getPeerAuthInit());
        map.put(header + "peerAuthenticator", this.getPeerAuthenticator());
        if (this.peerExtraPrmsClass != null) {
            map.put(header + "peerExtraProperties", this.getPeerExtraPrmsClass() + " defaults: " + this.convertSecurityPrms(this.getPeerExtraPrms()));
        }
        map.put(header + "peerVerifymemberTimeout", this.getPeerVerifymemberTimeout());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(SecurityPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            SecurityDescription sd = SecurityDescription.createSecurityDescription(name, config, i);
            config.addSecurityDescription(sd);
        }
    }

    private static SecurityDescription createSecurityDescription(String name, TestConfig config, int index) {
        Integer i;
        Class cls;
        ConfigHashtable tab = config.getParameters();
        SecurityDescription sd = new SecurityDescription();
        sd.setName(name);
        Long key = SecurityPrms.clientAccessor;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null || str.equalsIgnoreCase("none")) {
            str = "";
        }
        sd.setClientAccessor(SecurityDescription.parseMethod(key, str, null, AccessControl.class));
        key = SecurityPrms.clientAccessorPP;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null || str.equalsIgnoreCase("none")) {
            str = "";
        }
        sd.setClientAccessorPP(SecurityDescription.parseMethod(key, str, null, AccessControl.class));
        key = SecurityPrms.clientAuthInit;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null || str.equalsIgnoreCase("none")) {
            str = "";
        }
        sd.setClientAuthInit(SecurityDescription.parseMethod(key, str, null, AuthInitialize.class));
        key = SecurityPrms.clientAuthenticator;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null || str.equalsIgnoreCase("none")) {
            str = "";
        }
        sd.setClientAuthenticator(SecurityDescription.parseMethod(key, str, null, Authenticator.class));
        key = SecurityPrms.clientExtraProperties;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            cls = SecurityDescription.getClass(key, str);
            sd.setClientExtraPrmsClass(cls.getName());
            sd.setClientExtraPrms(SecurityDescription.getParametersAndDefaults(key, cls));
        }
        if ((str = tab.getString(key = SecurityPrms.logLevel, tab.getWild(key, index, null))) == null) {
            str = LogWriterImpl.levelToString((int)700);
        }
        sd.setLogLevel(str);
        key = SecurityPrms.peerAuthInit;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null || str.equalsIgnoreCase("none")) {
            str = "";
        }
        sd.setPeerAuthInit(SecurityDescription.parseMethod(key, str, null, AuthInitialize.class));
        key = SecurityPrms.peerAuthenticator;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null || str.equalsIgnoreCase("none")) {
            str = "";
        }
        sd.setPeerAuthenticator(SecurityDescription.parseMethod(key, str, null, Authenticator.class));
        key = SecurityPrms.peerExtraProperties;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            cls = SecurityDescription.getClass(key, str);
            sd.setPeerExtraPrmsClass(cls.getName());
            sd.setPeerExtraPrms(SecurityDescription.getParametersAndDefaults(key, cls));
        }
        if ((i = tab.getInteger(key = SecurityPrms.peerVerifymemberTimeout, tab.getWild(key, index, null))) == null) {
            i = new Integer(1000);
        }
        sd.setPeerVerifymemberTimeout(i);
        return sd;
    }

    private SortedMap convertSecurityPrms(Map prms) {
        TreeMap map = new TreeMap();
        for (Long key : prms.keySet()) {
            map.put(this.convertSecurityPrm(key), prms.get(key));
        }
        return map;
    }

    private String convertSecurityPrm(Long key) {
        return "security-" + this.convertPrm(key);
    }
}

