/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.SimpleTaskScheduler;
import hydra.TestTask;
import java.util.Vector;

public class SimpleConcurrentTaskScheduler
extends SimpleTaskScheduler {
    public SimpleConcurrentTaskScheduler(String name, Vector tasks, String purpose) {
        super(name, tasks, purpose);
    }

    @Override
    protected boolean executeTasks() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            TestTask task = (TestTask)this.tasks.get(i);
            if (task.batch()) {
                this.scheduleInBatches(task);
            } else if (task.sequential()) {
                this.scheduleSequentially(task);
            } else {
                this.schedule(task);
            }
            if (!this.executedNormallyOrNoHaltOrder()) break;
        }
        return this.schedulerResult();
    }

    private void scheduleInBatches(TestTask task) {
        int count;
        Vector<ClientRecord> clients;
        long now = 0L;
        do {
            clients = new Vector<ClientRecord>();
            count = 0;
            now = System.currentTimeMillis();
            for (ClientVmRecord vm : this.vms.values()) {
                for (ClientRecord client : vm.getClients().values()) {
                    if (!this.schedule(client, task, now)) continue;
                    clients.add(client);
                    ++count;
                }
            }
        } while (!this.terminateScheduling(clients, task, count, now = this.waitForClientsToFinish(clients)));
        this.log.info(this.name + " terminating scheduling because " + this.termination);
    }

    private void schedule(TestTask task) {
        Vector<ClientRecord> clients = new Vector<ClientRecord>();
        long now = System.currentTimeMillis();
        for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                if (!this.schedule(client, task, now)) continue;
                clients.add(client);
            }
        }
        this.waitForClientsToFinish(clients);
    }

    private void scheduleSequentially(TestTask task) {
        block0: for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                long now;
                if (this.schedule(client, task, now = System.currentTimeMillis())) {
                    this.waitForClientToFinish(client);
                }
                if (this.executedNormally()) continue;
                continue block0;
            }
        }
    }
}

