/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.SimpleTaskScheduler;
import hydra.TestTask;
import java.util.Vector;

public class SimpleSerialTaskScheduler
extends SimpleTaskScheduler {
    public SimpleSerialTaskScheduler(String name, Vector tasks, String purpose) {
        super(name, tasks, purpose);
    }

    @Override
    protected boolean executeTasks() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            TestTask task = (TestTask)this.tasks.get(i);
            if (task.batch()) {
                this.scheduleInBatches(task);
            } else {
                this.schedule(task);
            }
            if (!this.executedNormallyOrNoHaltOrder()) break;
        }
        return this.schedulerResult();
    }

    private void scheduleInBatches(TestTask task) {
        for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                int count = 0;
                long now = 0L;
                do {
                    if (!this.schedule(client, task, now)) continue;
                    ++count;
                    now = this.waitForClientToFinish(client);
                } while (!this.terminateScheduling(client, task, count, now));
            }
        }
    }

    private void schedule(TestTask task) {
        block0: for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                long now;
                if (this.schedule(client, task, now = System.currentTimeMillis())) {
                    this.waitForClientToFinish(client);
                }
                if (this.executedNormally()) continue;
                continue block0;
            }
        }
    }
}

