/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import util.TestHelper;

public class TestConfigComparison {
    public static List[] getLatestConfDiffs(List dirs) {
        if (dirs == null) {
            throw new HydraRuntimeException("No test directories provided");
        }
        List[] diffs = new List[dirs.size()];
        if (dirs.size() == 1) {
            return diffs;
        }
        Vector<SortedSet<String>> sets = new Vector<SortedSet<String>>();
        for (String dir : dirs) {
            try {
                SortedSet<String> set = FileUtil.getTextAsSet(dir + "/latest.conf");
                sets.add(set);
            }
            catch (FileNotFoundException e) {
                Log.getLogWriter().warning("...skipping " + dir + " for lack of a latest.conf file");
                sets.add(null);
            }
            catch (IOException e) {
                throw new HydraRuntimeException("Problem reading file", e);
            }
        }
        for (int i = 0; i < sets.size(); ++i) {
            SortedSet set = (SortedSet)sets.elementAt(i);
            if (set == null) {
                diffs[i] = null;
                continue;
            }
            diffs[i] = new ArrayList();
            block5: for (String entry : set) {
                for (int j = 0; j < sets.size(); ++j) {
                    SortedSet other;
                    if (j == i || (other = (SortedSet)sets.elementAt(j)) == null || other.contains(entry)) continue;
                    diffs[i].add(entry);
                    continue block5;
                }
            }
        }
        return diffs;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: TestConfigComparison <testDirs>");
            System.exit(1);
        }
        ArrayList<String> fns = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            fns.add(args[i]);
        }
        try {
            List[] diffs = TestConfigComparison.getLatestConfDiffs(fns);
            for (int i = 0; i < diffs.length; ++i) {
                System.out.println(args[i] + "\n" + diffs[i] + "\n");
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            System.out.println(TestHelper.getStackTrace(t));
            System.exit(1);
        }
    }
}

