/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestConfigFcns {
    private static GsRandom rng = new GsRandom();

    public static String generateNames(String prefix, int n) {
        return TestConfigFcns.generateNames(prefix, n, false);
    }

    public static String generateNames(String prefix, String n, boolean useComma) {
        Integer intValue = Integer.valueOf(n);
        return TestConfigFcns.generateNames(prefix, (int)intValue, useComma);
    }

    public static String generateNames(String prefix, int n, boolean useComma) {
        String v = "";
        for (int i = 1; i <= n; ++i) {
            v = v + prefix + i;
            if (i >= n) continue;
            if (useComma) {
                v = v + ",";
            }
            v = v + " ";
        }
        return v;
    }

    public static String generateNamesString(String prefix, int n, boolean useComma) {
        String v = "";
        for (int i = 1; i <= n; ++i) {
            v = v + "\"" + prefix + i + "\"";
            if (i >= n) continue;
            if (useComma) {
                v = v + ",";
            }
            v = v + " ";
        }
        return v;
    }

    public static String generateNames(String prefix, int n, int m) {
        return TestConfigFcns.generateNames(prefix, n, m, false);
    }

    public static String generateNames(String prefix, int n, int m, boolean useComma) {
        String v = "";
        for (int i = m; i < m + n; ++i) {
            v = v + prefix + i;
            if (i >= m + n - 1) continue;
            if (useComma) {
                v = v + ",";
            }
            v = v + " ";
        }
        return v;
    }

    public static String generateNamesRepeatedly(String prefix, int n, int m, boolean varyFirst) {
        String v = "";
        if (varyFirst) {
            for (int j = 1; j <= m; ++j) {
                for (int i = 1; i <= n; ++i) {
                    v = v + prefix + i;
                    if (i * j >= m * n) continue;
                    v = v + " ";
                }
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                for (int j = 1; j <= m; ++j) {
                    v = v + prefix + i;
                    if (i * j >= m * n) continue;
                    v = v + " ";
                }
            }
        }
        return v;
    }

    public static String generateNamesRepeatedlyShift(String prefix, int n, int m, boolean varyFirst, boolean useComma) {
        String v = "";
        if (varyFirst) {
            for (int j = 1; j <= m; ++j) {
                for (int i = 1; i <= n; ++i) {
                    int suffix = i % n + 1;
                    v = v + prefix + suffix;
                    if (i * j >= m * n) continue;
                    if (useComma) {
                        v = v + ",";
                    }
                    v = v + " ";
                }
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                for (int j = 1; j <= m; ++j) {
                    int suffix = i % n + 1;
                    v = v + prefix + suffix;
                    if (i * j >= m * n) continue;
                    if (useComma) {
                        v = v + ",";
                    }
                    v = v + " ";
                }
            }
        }
        return v;
    }

    public static String generateNameListsRepeatedlyShift(String prefix, int n, int m) {
        String v = "";
        for (int i = 1; i <= n; ++i) {
            String list = "";
            for (int k = 0; k < n - 1; ++k) {
                int suffix = (i + k) % n + 1;
                list = list + prefix + suffix;
                if (k >= n - 2) continue;
                list = list + " ";
            }
            for (int j = 1; j <= m; ++j) {
                v = v + list;
                if (i * j >= m * n) continue;
                v = v + ", ";
            }
        }
        return v;
    }

    public static String generateDoubleSuffixedNames(String prefix, int n, int m, boolean varyFirst) {
        return TestConfigFcns.generateDoubleSuffixedNames(prefix, n, m, varyFirst, false);
    }

    public static String generateDoubleSuffixedNames(String prefix, int n, int m, boolean varyFirst, boolean useComma) {
        String v = "";
        if (varyFirst) {
            for (int j = 1; j <= m; ++j) {
                for (int i = 1; i <= n; ++i) {
                    v = v + prefix + "_" + i + "_" + j;
                    if (i * j >= m * n) continue;
                    if (useComma) {
                        v = v + ",";
                    }
                    v = v + " ";
                }
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                for (int j = 1; j <= m; ++j) {
                    v = v + prefix + "_" + i + "_" + j;
                    if (i * j >= m * n) continue;
                    if (useComma) {
                        v = v + ",";
                    }
                    v = v + " ";
                }
            }
        }
        return v;
    }

    public static String generateDoubleSuffixedRunsOfNames(String prefix, int n, int m, boolean varyFirst) {
        String v = "";
        if (varyFirst) {
            for (int j = 1; j <= m; ++j) {
                for (int i = 1; i <= n; ++i) {
                    v = v + prefix + "_" + i + "_" + j;
                    if (i >= n) continue;
                    v = v + " ";
                }
                if (j >= m) continue;
                v = v + ", ";
            }
        } else {
            for (int i = 1; i <= n; ++i) {
                for (int j = 1; j <= m; ++j) {
                    v = v + prefix + "_" + i + "_" + j;
                    if (j >= m) continue;
                    v = v + " ";
                }
                if (i >= n) continue;
                v = v + ", ";
            }
        }
        return v;
    }

    public static String generateDoubleSuffixedFixedNames(String prefix, int n, int m) {
        return TestConfigFcns.generateDoubleSuffixedFixedNames(prefix, n, m, false);
    }

    public static String generateDoubleSuffixedFixedNames(String prefix, int n, int m, boolean useComma) {
        String v = "";
        for (int j = 1; j <= m; ++j) {
            v = v + prefix + "_" + n + "_" + j;
            if (n * j >= m * n) continue;
            if (useComma) {
                v = v + ",";
            }
            v = v + " ";
        }
        return v;
    }

    public static String duplicate(String val, int n) {
        return TestConfigFcns.duplicate(val, n, false);
    }

    public static String duplicateEnforced(String val, String enforced, int n) {
        if (val == null) {
            String s = "Provided value cannot be null";
            throw new HydraConfigException(s);
        }
        if (enforced == null) {
            String s = "Enforced value cannot be null";
            throw new HydraConfigException(s);
        }
        if (!val.equals(enforced)) {
            String s = "Value is enforced to be \"" + enforced + "\"" + ", cannot be set to \"" + val + "\"";
            throw new HydraConfigException(s);
        }
        return TestConfigFcns.duplicate(enforced, n, false);
    }

    public static String duplicate(String val, int n, boolean useComma) {
        String v = "";
        for (int i = 1; i <= n; ++i) {
            v = v + val;
            if (i >= n) continue;
            if (useComma) {
                v = v + ",";
            }
            v = v + " ";
        }
        return v;
    }

    public static String duplicateString(String val, int n, boolean useComma) {
        String v = "";
        for (int i = 1; i <= n; ++i) {
            v = v + "\"" + val + "\"";
            if (i >= n) continue;
            if (useComma) {
                v = v + ",";
            }
            v = v + " ";
        }
        return v;
    }

    public static String pool(String list, int n) {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, " ", false);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        String v = "";
        for (int i = 0; i < n; ++i) {
            v = v + tokens.elementAt(i % tokens.size());
            if (i >= n - 1) continue;
            v = v + " ";
        }
        return v;
    }

    public static String poolList(String listOfLists, int n) {
        String v = "";
        StringTokenizer listTokenizer = new StringTokenizer(listOfLists, ",", false);
        while (listTokenizer.hasMoreTokens()) {
            String list = listTokenizer.nextToken();
            Vector<String> tokens = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(list, " ", false);
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken().trim());
            }
            for (int i = 0; i < n; ++i) {
                v = v + tokens.elementAt(i % tokens.size());
                v = v + " ";
            }
        }
        return v.trim();
    }

    public static String poolList(String listOfLists, int n, int m) {
        if (n <= 0 || m <= 0) {
            throw new IllegalArgumentException("integer arguments must be positive");
        }
        String v = "";
        int count = 0;
        block0: while (true) {
            StringTokenizer listTokenizer = new StringTokenizer(listOfLists, ",", false);
            do {
                if (!listTokenizer.hasMoreTokens()) continue block0;
                String list = listTokenizer.nextToken();
                Vector<String> tokens = new Vector<String>();
                StringTokenizer tokenizer = new StringTokenizer(list, " ", false);
                while (tokenizer.hasMoreTokens()) {
                    tokens.add(tokenizer.nextToken().trim());
                }
                for (int i = 0; i < n; ++i) {
                    v = v + tokens.elementAt(i % tokens.size());
                    v = v + " ";
                }
            } while (++count != m);
            break;
        }
        return v.trim();
    }

    public static String poolListOfLists(String listOfLists, int n) {
        ArrayList<String> lists = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(listOfLists, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String list = tokenizer.nextToken();
            lists.add(list.trim());
        }
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + (String)lists.get(i % lists.size());
            if (i != n - 1) {
                s = s + ",";
            }
            s = s + " ";
        }
        return s;
    }

    public static String oneof(String arg0, String arg1) {
        switch (rng.nextInt(0, 1)) {
            case 0: {
                return arg0;
            }
            case 1: {
                return arg1;
            }
        }
        throw new HydraInternalException("Should not happen");
    }

    public static String oneof(String arg0, String arg1, String arg2) {
        switch (rng.nextInt(0, 2)) {
            case 0: {
                return arg0;
            }
            case 1: {
                return arg1;
            }
            case 2: {
                return arg2;
            }
        }
        throw new HydraInternalException("Should not happen");
    }
}

