/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.Nuker;
import hydra.Platform;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class TestFileUtil {
    private static String[] DISK_FILE_PREFIXES = new String[]{"RECOVERY_STATE_"};
    private static String[] DISK_FILE_SUFFIXES = new String[]{".krf", ".idxkrf", ".crf", ".db", ".drf", ".hlk", ".if", ".lg", ".lk", ".olg"};
    private static final String OPERATION = "operation";
    private static final String TARGET = "target";
    private static final String LIST = "list";
    private static final String GEN_VSD = "genVSD";
    private static final String SYSDIRS = "sysdirs";
    private static final String STATARCHIVES = "statarchives";

    public static List getConfigFiles() {
        String jtests = System.getProperty("JTESTS");
        List configFiles = TestFileUtil.getFilesEndingWith(jtests, ".conf");
        String extraJtests = System.getProperty("EXTRA_JTESTS");
        if (extraJtests != null) {
            List extraJtestsFiles = TestFileUtil.getFilesEndingWith(extraJtests, ".conf");
            Iterator i = extraJtestsFiles.iterator();
            while (i.hasNext()) {
                configFiles.add(i.next());
            }
        }
        return configFiles;
    }

    private static List getFilesEndingWith(String dirname, String suffix) {
        class EndsWithFilter
        implements FileFilter {
            String suffix;

            public EndsWithFilter(String suffix) {
                this.suffix = suffix;
            }

            @Override
            public boolean accept(File fn) {
                return !fn.isDirectory() && fn.getName().endsWith(this.suffix);
            }
        }
        return FileUtil.getFiles(new File(dirname), new EndsWithFilter(suffix), true);
    }

    public static List getTestDirectories(String dirname, boolean recursive) {
        return FileUtil.getFiles(new File(dirname), new TestDirFilter(), recursive);
    }

    public static boolean isTestDirectory(String dirname) {
        return new TestDirFilter().accept(new File(dirname));
    }

    public static String getShortTestName(String dirname) {
        String fn = FileUtil.filenameFor(dirname);
        int hyphen2 = fn.lastIndexOf(45);
        int hyphen1 = fn.lastIndexOf(45, hyphen2 - 1);
        return fn.substring(0, hyphen1);
    }

    protected static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static List<String> getSystemDirectoriesAsList(String masterUserDir) {
        SortedMap sysdirMap = TestFileUtil.getSystemDirectories(masterUserDir);
        return sysdirMap == null ? null : TestFileUtil.mapOfListsToList(sysdirMap);
    }

    private static SortedMap getSystemDirectories(String masterUserDir) {
        List<String> tokens;
        TreeMap<String, ArrayList<String>> dirmap = new TreeMap<String, ArrayList<String>>();
        String fn = null;
        if (HostHelper.getLocalHostOS() == HostHelper.OSType.unix) {
            fn = masterUserDir + File.separator + "unix_sysdirs.txt";
        } else if (HostHelper.getLocalHostOS() == HostHelper.OSType.windows) {
            fn = System.getProperty("user.dir") + File.separator + "windows_sysdirs.txt";
        } else {
            throw new HydraInternalException("Should not happen");
        }
        try {
            tokens = FileUtil.getTextAsTokens(fn);
        }
        catch (FileNotFoundException e) {
            return dirmap;
        }
        catch (IOException e) {
            String s = "Unable to open file: " + fn;
            throw new HydraRuntimeException(s);
        }
        if (tokens.size() % 2 != 0) {
            String s = fn + " is corrupt";
            throw new HydraRuntimeException(s);
        }
        for (int i = 0; i < tokens.size(); i += 2) {
            ArrayList<String> dirs;
            String name = tokens.get(i);
            String dir = tokens.get(i + 1);
            if (!FileUtil.exists(dir)) {
                String localdir = masterUserDir + "/" + FileUtil.filenameFor(dir);
                if (FileUtil.exists(localdir)) {
                    dir = localdir;
                } else {
                    Log.getLogWriter().warning("Missing directory: " + dir);
                    dir = null;
                }
            }
            if ((dirs = (ArrayList<String>)dirmap.get(name)) == null) {
                dirs = new ArrayList<String>();
                dirmap.put(name, dirs);
            }
            if (dir == null) continue;
            dirs.add(dir);
        }
        return dirmap;
    }

    private static List getDirectoriesStartingWith(String dirname, String prefix) {
        class StartsWithFilter
        implements FileFilter {
            String prefix;

            public StartsWithFilter(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public boolean accept(File fn) {
                return fn.isDirectory() && fn.getName().startsWith(this.prefix);
            }
        }
        return FileUtil.getFiles(new File(dirname), new StartsWithFilter(prefix), false);
    }

    protected static void removeDiskFilesAfterTest() {
        Set dirs = Nuker.getInstance().getDirectories();
        for (String dir : dirs) {
            TestFileUtil.removeDiskFiles(new File(dir));
        }
    }

    private static void removeDiskFiles(File dir) {
        class DiskFileFilter
        implements FileFilter {
            @Override
            public boolean accept(File fn) {
                String fname = fn.getName();
                for (String prefix : DISK_FILE_PREFIXES) {
                    if (!fname.startsWith(prefix)) continue;
                    return true;
                }
                for (String suffix : DISK_FILE_SUFFIXES) {
                    if (!fname.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }
        }
        List dirs = FileUtil.getFiles(dir, new DiskFileFilter(), true);
        for (File diskFile : dirs) {
            long sz = diskFile.length();
            boolean result = diskFile.delete();
            if (result) {
                Log.getLogWriter().info("Removed " + diskFile.getAbsolutePath() + " at " + sz + " bytes");
                continue;
            }
            Log.getLogWriter().info("Was unable to remove " + diskFile.getAbsolutePath() + " at " + sz + " bytes");
        }
    }

    public static List getMergeLogFiles(String masterUserDir) {
        TreeSet allLogs = new TreeSet();
        SortedMap sysdirmap = TestFileUtil.getSystemDirectories(masterUserDir);
        for (String name : sysdirmap.keySet()) {
            for (String sysdir : (List)sysdirmap.get(name)) {
                List logs = TestFileUtil.getFilesEndingWith(sysdir, ".log");
                if (logs.size() == 0) continue;
                allLogs.addAll(logs);
            }
        }
        List logs = TestFileUtil.getFilesEndingWith(masterUserDir, ".log");
        allLogs.addAll(logs);
        return allLogs.size() == 0 ? null : new ArrayList(allLogs);
    }

    public static List getNativeClientStatisticArchivesAsList(String masterUserDir) {
        List archives = TestFileUtil.getFilesStartingWithEndingWith(masterUserDir, "statArchive", ".gfs");
        return archives.size() == 0 ? null : archives;
    }

    public static List<String> getStatisticArchivesAsList(String masterUserDir) {
        SortedMap<String, List<String>> archiveMap = TestFileUtil.getStatisticArchives(masterUserDir);
        return archiveMap == null ? null : TestFileUtil.mapOfListsToList(archiveMap);
    }

    public static SortedMap<String, List<String>> getStatisticArchives(String masterUserDir) {
        TreeMap<String, List<String>> archivemap = new TreeMap<String, List<String>>();
        SortedMap sysdirmap = TestFileUtil.getSystemDirectories(masterUserDir);
        for (String name : sysdirmap.keySet()) {
            for (String sysdir : (List)sysdirmap.get(name)) {
                List archives = TestFileUtil.getFilesStartingWithEndingWith(sysdir, "statArchive", ".gfs");
                if (archives.size() == 0) continue;
                List existingArchives = (List)archivemap.get(name);
                if (existingArchives == null) {
                    archivemap.put(name, archives);
                    continue;
                }
                existingArchives.addAll(archives);
            }
        }
        return archivemap.size() == 0 ? null : archivemap;
    }

    private static List getFilesStartingWithEndingWith(String dirname, String prefix, String suffix) {
        class StartsWithEndsWithFilter
        implements FileFilter {
            String prefix;
            String suffix;

            public StartsWithEndsWithFilter(String prefix, String suffix) {
                this.prefix = prefix;
                this.suffix = suffix;
            }

            @Override
            public boolean accept(File fn) {
                return fn.getName().startsWith(this.prefix) && fn.getName().endsWith(this.suffix);
            }
        }
        return FileUtil.getFiles(new File(dirname), new StartsWithEndsWithFilter(prefix, suffix), true);
    }

    private static List<String> mapOfListsToList(SortedMap<String, List<String>> mapOfLists) {
        ArrayList<String> list = new ArrayList<String>();
        Collection<List<String>> sublists = mapOfLists.values();
        if (sublists != null) {
            for (List<String> sublist : sublists) {
                if (sublist == null) continue;
                list.addAll(sublist);
            }
        }
        return list.size() == 0 ? null : list;
    }

    private static void listSysDirs(String testDir) throws FileNotFoundException, IOException {
        List<String> dirList = TestFileUtil.getSystemDirectoriesAsList(testDir);
        Iterator<String> i = dirList.iterator();
        while (i.hasNext()) {
            System.out.println((Object)i.next());
        }
    }

    private static void listStatArchives(String testDir) throws FileNotFoundException, IOException {
        List<String> dirList = TestFileUtil.getStatisticArchivesAsList(testDir);
        Iterator<String> i = dirList.iterator();
        while (i.hasNext()) {
            System.out.println((Object)i.next());
        }
    }

    private static void genVSD(String testDir) throws FileNotFoundException, IOException {
        List<String> dirList = TestFileUtil.getStatisticArchivesAsList(testDir);
        if (dirList == null) {
            System.out.println("No archives yet for " + testDir);
        } else {
            StringBuffer buf = new StringBuffer();
            Platform platform = Platform.getInstance();
            buf.append(platform.getScriptHeader() + platform.getCommentPrefix() + " execute this script to run vsd on all archives, including remote ones, for a test that is still running\nvsd ");
            Iterator<String> i = dirList.iterator();
            while (i.hasNext()) {
                buf.append(i.next() + " ");
            }
            String fn = testDir + File.separator + "vsd" + platform.getFileExtension();
            FileUtil.appendToFile(fn, buf + "\n");
            platform.setExecutePermission(fn);
            System.out.println("\n\nSee " + fn + "\n");
        }
    }

    private static void usage(String s) {
        System.err.println(s);
        TestFileUtil.usage();
    }

    private static void usage() {
        System.err.println("Usage:  hydra.TestFileUtil operation target [<test_directory(default:$PWD)>]\n\twhere\n\t\toperation=list|genVSD\n\t\ttarget=sysdirs|statarchives");
        System.exit(1);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String testDir;
        Log.createLogWriter("testFileUtil", "info");
        if (args.length < 2 || args.length > 3) {
            TestFileUtil.usage();
        }
        String operation = args[0];
        String target = args[1];
        String string = testDir = args.length == 3 ? new File(args[2]).getAbsolutePath() : System.getProperty("user.dir");
        if (operation.equals(LIST)) {
            if (target.equals(SYSDIRS)) {
                TestFileUtil.listSysDirs(testDir);
            } else if (target.equals(STATARCHIVES)) {
                TestFileUtil.listStatArchives(testDir);
            } else {
                TestFileUtil.usage("Unsupported target: " + target);
            }
        } else if (operation.equals(GEN_VSD)) {
            if (target.equals(STATARCHIVES)) {
                TestFileUtil.genVSD(testDir);
            } else if (target.equals(SYSDIRS)) {
                TestFileUtil.usage("\"genVSD\" only supports \"statarchives\"");
                System.exit(1);
            } else {
                TestFileUtil.usage("Unsupported target: " + target);
            }
        } else {
            TestFileUtil.usage("Unsupported operation: " + operation);
        }
    }

    public static SortedMap getSystemDirectories(List<String> logicalSystemNames, String masterUserDir) {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        for (String logicalSystemName : logicalSystemNames) {
            String parentDirectory;
            List<String> sysdirs = TestFileUtil.getSystemDirectories(logicalSystemName, parentDirectory = masterUserDir);
            if (sysdirs.size() <= 0) continue;
            map.put(logicalSystemName, sysdirs);
        }
        return map;
    }

    public static List<String> getSystemDirectories(String logicalSystemName, String parentDirectory) {
        List l1 = TestFileUtil.getDirectory(parentDirectory + File.separator + logicalSystemName);
        List l2 = TestFileUtil.getDirectoriesStartingWith(parentDirectory, logicalSystemName + "_");
        l1.addAll(l2);
        return l1;
    }

    private static List getDirectory(String dirname) {
        ArrayList<File> l = new ArrayList<File>();
        File dir = new File(dirname);
        if (dir.exists()) {
            l.add(dir);
        }
        return l;
    }

    public static List getStatisticArchivesAsList(List logicalSystemNames, String masterUserDir) {
        ArrayList archives = new ArrayList();
        SortedMap archiveMap = TestFileUtil.getStatisticArchives(logicalSystemNames, masterUserDir);
        if (archiveMap != null) {
            for (List archiveList : archiveMap.values()) {
                if (archiveList == null) continue;
                archives.addAll(archiveList);
            }
        }
        return archives.size() == 0 ? null : archives;
    }

    public static SortedMap getStatisticArchives(List logicalSystemNames, String masterUserDir) {
        TreeMap<String, List> map = new TreeMap<String, List>();
        SortedMap systemDirectories = TestFileUtil.getSystemDirectories(logicalSystemNames, masterUserDir);
        for (String logicalSystemName : logicalSystemNames) {
            List parentDirectories = (List)systemDirectories.get(logicalSystemName);
            if (parentDirectories == null) continue;
            List archives = TestFileUtil.getStatisticArchives(parentDirectories);
            map.put(logicalSystemName, archives);
        }
        return map;
    }

    private static List getStatisticArchives(List parentDirectories) {
        ArrayList archives = new ArrayList();
        for (File parentDirectory : parentDirectories) {
            List l = TestFileUtil.getFilesStartingWithEndingWith(parentDirectory.getAbsolutePath(), "statArchive", ".gfs");
            if (l == null || l.size() == 0) continue;
            archives.addAll(l);
        }
        return archives.size() == 0 ? null : archives;
    }

    static class TestDirFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            String fn = f.getName();
            int hyphen2 = fn.lastIndexOf(45);
            int hyphen1 = fn.lastIndexOf(45, hyphen2 - 1);
            return f.isDirectory() && hyphen1 != -1 && hyphen1 + 4 + 1 == hyphen2 && hyphen2 + 6 + 1 == fn.length() && TestFileUtil.isDigits(fn.substring(hyphen1 + 1, hyphen2)) && TestFileUtil.isDigits(fn.substring(hyphen2 + 1, fn.length()));
        }
    }
}

