/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import hydra.ProductVersionHelper;
import hydra.TestConfig;
import hydra.VmPrms;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;

public class VmDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private HostDescription hd;
    private String type;
    private String classPath;
    private List<String> gemfirexdClassPaths;
    private String libPath;
    private transient Vector unconvertedExtraClassPath;
    private transient Vector unconvertedExtraLibPath;
    private String extraVMArgs;

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public HostDescription getHostDescription() {
        return this.hd;
    }

    protected void setHostDescription(HostDescription hd) {
        this.hd = hd;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getClassPath() {
        if (this.gemfirexdClassPaths == null) {
            return this.classPath;
        }
        String tmp = this.classPath;
        for (String gemfirexdClassPath : this.gemfirexdClassPaths) {
            tmp = gemfirexdClassPath + this.hd.getPathSep() + tmp;
        }
        return tmp;
    }

    protected void setClassPath(String path) {
        this.classPath = path;
    }

    public List<String> getGemFireXDClassPaths() {
        return this.gemfirexdClassPaths;
    }

    public void setGemFireXDClassPaths(List<String> paths) {
        this.gemfirexdClassPaths = paths;
    }

    public String getLibPath() {
        return this.libPath;
    }

    protected void setLibPath(String path) {
        this.libPath = path;
    }

    public String getExtraVMArgs() {
        return this.extraVMArgs;
    }

    public void setExtraVMArgs(String args) {
        this.extraVMArgs = args;
    }

    public void addExtraVMArg(String arg) {
        this.extraVMArgs = this.extraVMArgs + " " + arg;
    }

    public Vector getUnconvertedExtraClassPath() {
        return this.unconvertedExtraClassPath;
    }

    protected void setUnconvertedExtraClassPath(Vector path) {
        this.unconvertedExtraClassPath = path;
    }

    public Vector getUnconvertedExtraLibPath() {
        return this.unconvertedExtraLibPath;
    }

    protected void setUnconvertedExtraLibPath(Vector path) {
        this.unconvertedExtraLibPath = path;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "hostName", this.getHostDescription().getName());
        map.put(header + "type", this.getType());
        if (this.getClassPath() != null) {
            map.put(header + "classPath", this.getClassPath());
        }
        if (this.getLibPath() != null) {
            map.put(header + "libPath", this.getLibPath());
        }
        if (this.getExtraVMArgs() != null) {
            map.put(header + "extraVMArgs", this.getExtraVMArgs());
        }
        return map;
    }

    protected static String getSnappyJarPath(String jarPath, final String jarName) {
        String snappyJar = null;
        try {
            File parent = new File(jarPath);
            File[] files = parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(jarName);
                }
            });
            File snappyJarFile = files[0];
            snappyJar = snappyJarFile.getAbsolutePath();
        }
        catch (Exception e) {
            Log.getLogWriter().info("Unable to find " + jarName + " jar at " + jarPath + " location.");
        }
        return snappyJar;
    }

    protected static String getAllSnappyJars(String jarPath) {
        ArrayList<String> jarFiles = new ArrayList<String>();
        String SnappyJarsList = null;
        File baseDir = new File(jarPath);
        try {
            WildcardFileFilter filter = new WildcardFileFilter("*.jar");
            List files = (List)FileUtils.listFiles((File)baseDir, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE);
            Log.getLogWriter().info("Jar files found: " + Arrays.asList(files));
            for (File file1 : files) {
                jarFiles.add(file1.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Log.getLogWriter().info("Unable to find " + jarPath + " location.");
        }
        SnappyJarsList = StringUtils.join(jarFiles, (String)":");
        return SnappyJarsList;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(VmPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            VmDescription vmd = new VmDescription();
            String name = (String)names.elementAt(i);
            vmd.setName(name);
            String hostName = tab.stringAtWild(VmPrms.hostNames, i, null);
            if (hostName == null) {
                throw new HydraConfigException("Missing " + BasePrms.nameForKey(VmPrms.hostNames));
            }
            HostDescription hd = config.getHostDescription(hostName);
            if (hd == null) {
                throw new HydraConfigException("Undefined value in " + BasePrms.nameForKey(VmPrms.hostNames) + ": " + hostName);
            }
            vmd.setHostDescription(hd);
            String type = VmPrms.getType(i, hd.getJavaVendor());
            vmd.setType(type);
            Vector<String> classPath = new Vector<String>();
            Long key = VmPrms.extraClassPaths;
            Vector paths = tab.vecAtWild(key, i, null);
            if (paths != null) {
                Iterator it = paths.iterator();
                while (it.hasNext()) {
                    String path = tab.getString(key, it.next());
                    if (path != null && !path.equalsIgnoreCase("none")) continue;
                    it.remove();
                }
                vmd.setUnconvertedExtraClassPath(paths);
                if (paths.size() > 0) {
                    paths = EnvHelper.expandEnvVars(paths, hd);
                    classPath.addAll(paths);
                }
            }
            classPath.add(hd.getTestDir() + hd.getFileSep() + "junit.jar");
            classPath.add(hd.getTestDir());
            if (hd.getExtraTestDir() != null) {
                classPath.add(hd.getExtraTestDir());
            }
            if (hd.getGemFireHome() != null) {
                classPath.add(VmDescription.getAllSnappyJars(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "snappy" + hd.getFileSep() + "jars"));
            }
            classPath.add(hd.getTestDir() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "libs" + hd.getFileSep() + "snappydata-store-hydra-tests-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + "-all.jar");
            classPath.add(VmDescription.getSnappyJarPath(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "dtests" + hd.getFileSep() + "build-artifacts" + hd.getFileSep() + "scala-2.11" + hd.getFileSep() + "libs", "snappydata-store-scala-tests"));
            vmd.setClassPath(EnvHelper.asPath(classPath, hd));
            Vector<String> libPath = new Vector<String>();
            if (hd.getGemFireHome() != null) {
                libPath.add(hd.getGemFireHome() + hd.getFileSep() + "lib");
                libPath.add(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "hidden" + hd.getFileSep() + "lib");
            }
            Vector extraLibPath = tab.vecAtWild(VmPrms.extraLibPaths, i, null);
            vmd.setUnconvertedExtraLibPath(extraLibPath);
            if (extraLibPath != null) {
                extraLibPath = EnvHelper.expandEnvVars(extraLibPath, hd);
                libPath.addAll(extraLibPath);
            }
            vmd.setLibPath(EnvHelper.asPath(libPath, hd));
            String extraVMArgs = VmPrms.getExtraVMArgs(i, hd.getJavaVendor(), vmd.getType());
            vmd.setExtraVMArgs(extraVMArgs.trim());
            config.addVmDescription(vmd);
        }
    }
}

