/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.HostPrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;

public class VmPrms
extends BasePrms {
    public static Long names;
    public static Long hostNames;
    public static Long type;
    public static final String CLIENT = "client";
    public static final String SERVER = "server";
    public static final String SERVER64 = "d64";
    public static Long extraClassPaths;
    public static Long extraLibPaths;
    public static Long extraVMArgs;
    public static Long extraVMArgsHitachi;
    public static Long extraVMArgsIBM;
    public static Long extraVMArgsJRockit;
    public static Long extraVMArgsApple;
    public static Long extraVMArgsSUN;
    public static final String DEFAULT_ARGS = "-Dsun.rmi.dgc.client.gcInterval=600000 -Dsun.rmi.dgc.server.gcInterval=600000 -Dsun.rmi.transport.tcp.handshakeTimeout=3600000 -Xmx250m -Dgemfire.disallowMcastDefaults=true";
    public static final String DEFAULT_SUN_4_ARGS = "-XX:+JavaMonitorsInStackTrace";
    public static final String DEFAULT_SUN_5_ARGS = "-XX:+JavaMonitorsInStackTrace -XX:+HeapDumpOnOutOfMemoryError";
    public static final String DEFAULT_HITACHI_ARGS = "-XX:+JavaMonitorsInStackTrace -XX:+HitachiOutOfMemoryStackTrace -XX:+HitachiOutOfMemoryCause -XX:+HitachiOutOfMemorySize";

    public static String getType(int i, String vendor) {
        if (vendor.equals("Sun") || vendor.equals("Hitachi")) {
            Long key = type;
            String val = VmPrms.tab().stringAtWild(key, i, SERVER);
            if (val.equalsIgnoreCase(CLIENT)) {
                return CLIENT;
            }
            if (val.equalsIgnoreCase(SERVER)) {
                return SERVER;
            }
            if (val.equalsIgnoreCase(SERVER64)) {
                return SERVER64;
            }
            throw new HydraConfigException("Illegal value for " + VmPrms.nameForKey(key) + ": " + val);
        }
        if (vendor.equals("JRockit")) {
            Long key = type;
            String val = VmPrms.tab().stringAtWild(key, i, SERVER);
            if (val.equalsIgnoreCase(CLIENT)) {
                return CLIENT;
            }
            if (val.equalsIgnoreCase(SERVER)) {
                return SERVER;
            }
            if (val.equalsIgnoreCase(SERVER64)) {
                return SERVER64;
            }
            throw new HydraConfigException("Illegal value for " + VmPrms.nameForKey(key) + ": " + val);
        }
        return null;
    }

    public static String defaultType() {
        String vendor = HostPrms.getJavaVendor();
        if (vendor.equals("Sun")) {
            return SERVER;
        }
        return null;
    }

    public static String getExtraVMArgs(int i, String vendor, String type) {
        String args = DEFAULT_ARGS;
        if (vendor.equals("Sun")) {
            args = System.getProperty("java.version").startsWith("1.4") ? args + " -XX:+JavaMonitorsInStackTrace" : args + " -XX:+JavaMonitorsInStackTrace -XX:+HeapDumpOnOutOfMemoryError";
        }
        if (vendor.equals("Hitachi")) {
            args = args + " -XX:+JavaMonitorsInStackTrace -XX:+HitachiOutOfMemoryStackTrace -XX:+HitachiOutOfMemoryCause -XX:+HitachiOutOfMemorySize";
        }
        args = args + " " + VmPrms.getVMArgs(extraVMArgs, i);
        if (vendor.equals("Hitachi")) {
            args = args + " " + VmPrms.getVMArgs(extraVMArgsHitachi, i);
        } else if (vendor.equals("IBM")) {
            args = args + " " + VmPrms.getVMArgs(extraVMArgsIBM, i);
        } else if (vendor.equals("JRockit")) {
            args = args + " " + VmPrms.getVMArgs(extraVMArgsJRockit, i);
        } else if (vendor.equals("Sun")) {
            args = args + " " + VmPrms.getVMArgs(extraVMArgsSUN, i);
        } else if (vendor.equals("Apple")) {
            args = args + " " + VmPrms.getVMArgs(extraVMArgsApple, i);
        } else {
            String s = "Unknown JVM vendor: " + vendor;
            throw new HydraInternalException(s);
        }
        if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
            if (args == null) {
                args = "";
            }
            args = args + " -Djava.net.preferIPv6Addresses=true";
        }
        if (TestConfig.tab().booleanAt(Prms.disableCreateBucketRandomness, false)) {
            if (args == null) {
                args = "";
            }
            args = args + " -Dgemfire.DISABLE_CREATE_BUCKET_RANDOMNESS=true";
        }
        return args;
    }

    private static String getVMArgs(Long key, int i) {
        String args = "";
        HydraVector val = VmPrms.tab().vecAtWild(key, i, null);
        if (val != null) {
            for (String arg : val) {
                if (arg.equals("=")) {
                    String s = "Malformed value in " + key + ", use quotes to include '='";
                    throw new HydraConfigException(s);
                }
                if (val.equals("none")) continue;
                args = args + " " + arg;
            }
        }
        return args;
    }

    public static void main(String[] args) {
        Log.createLogWriter("vmprms", "info");
        VmPrms.dumpKeys();
    }

    static {
        VmPrms.setValues(VmPrms.class);
    }
}

