/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import hydra.HydraRuntimeException;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCondition;
import hydra.blackboard.SharedLock;

public class AnyCyclicBarrier {
    private final SharedLock lock;
    private final SharedCondition condition;
    private final int parties;
    private BarrierBB bb;

    protected AnyCyclicBarrier(int parties, String lockName) {
        this.bb = new BarrierBB(lockName);
        this.bb.setParties(parties);
        this.parties = parties;
        this.lock = this.bb.getSharedLock();
        this.condition = this.lock.getCondition(lockName);
    }

    public static AnyCyclicBarrier lookup(int parties, String name) {
        return new AnyCyclicBarrier(parties, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() {
        block10: {
            if (this.parties == 1) {
                return;
            }
            this.lock.lock();
            try {
                long waiters = this.bb.incrementAndReadWaiters();
                if (waiters < 0L) {
                    throw new HydraRuntimeException("Barrier broken");
                }
                if (waiters % (long)this.parties == 0L) {
                    this.condition.signalAll();
                    break block10;
                }
                try {
                    long iteration = waiters / (long)this.parties;
                    do {
                        this.condition.await();
                    } while (iteration == (waiters = this.bb.readWaiters()) / (long)this.parties);
                }
                catch (InterruptedException e) {
                    this.bb.setBarrierBroken();
                    waiters = Long.MIN_VALUE;
                    this.condition.signalAll();
                }
                if (waiters < 0L) {
                    throw new HydraRuntimeException("Barrier broken");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class BarrierBB
    extends Blackboard {
        public static int parties;
        public static int waiters;

        public BarrierBB() {
        }

        public BarrierBB(String name) {
            super(name, 0, BarrierBB.class);
        }

        public void setParties(long newValue) {
            long oldValue = this.getSharedCounters().read(parties);
            if (oldValue != 0L) {
                if (oldValue != newValue) {
                    throw new HydraRuntimeException("Barrier already initialized with size " + oldValue + ", trying to intialize with size " + newValue);
                }
            } else {
                this.getSharedCounters().setIfLarger(parties, newValue);
            }
        }

        public long incrementAndReadWaiters() {
            long result = this.getSharedCounters().incrementAndRead(waiters);
            return result;
        }

        public long readWaiters() {
            long result = this.getSharedCounters().read(waiters);
            return result;
        }

        public void setBarrierBroken() {
            this.getSharedCounters().setIfSmaller(waiters, Long.MIN_VALUE);
        }
    }
}

