/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.blackboard.RmiSharedMap;
import hydra.blackboard.RmiSharedMapImpl;
import hydra.blackboard.SharedMap;
import java.rmi.RemoteException;
import java.util.Map;

public class AnySharedMapImpl
implements SharedMap {
    private String name;
    private int type = -1;
    private LogWriter log;
    private RmiSharedMap rmimap;

    public AnySharedMapImpl(String name, int type) {
        this.name = name;
        this.type = type;
        this.log = Log.getLogWriter();
    }

    protected void setRmiMap(RmiSharedMap rmim) {
        this.rmimap = rmim;
    }

    public static SharedMap bind(String name, int type) {
        switch (type) {
            case 0: {
                try {
                    RmiSharedMapImpl rmim = new RmiSharedMapImpl();
                    RmiSharedMapImpl.bind(name, rmim);
                    AnySharedMapImpl asmi = new AnySharedMapImpl(name, type);
                    asmi.setRmiMap(rmim);
                    return asmi;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to bind RMI map: " + name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + type);
    }

    public static SharedMap lookup(String name, int type) {
        switch (type) {
            case 0: {
                RmiSharedMap rmim = null;
                try {
                    rmim = RmiSharedMapImpl.lookup(name);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to look up RMI map: " + name, e);
                }
                if (rmim == null) {
                    return null;
                }
                AnySharedMapImpl asmi = new AnySharedMapImpl(name, type);
                asmi.setRmiMap(rmim);
                return asmi;
            }
        }
        throw new HydraInternalException("Illegal transport type: " + type);
    }

    @Override
    public int size() {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.size();
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public boolean isEmpty() {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.isEmpty();
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public boolean containsKey(Object key) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.containsKey(key);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public boolean containsValue(Object value) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.containsValue(value);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public Object get(Object key) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.get(key);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public Object put(Object key, Object value) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.put(key, value);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public long putIfLarger(Object key, long value) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.putIfLarger(key, value);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public long putIfSmaller(Object key, long value) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.putIfSmaller(key, value);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public Object remove(Object key) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.remove(key);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public void putAll(Map t) {
        switch (this.type) {
            case 0: {
                try {
                    this.rmimap.putAll(t);
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public void clear() {
        switch (this.type) {
            case 0: {
                try {
                    this.rmimap.clear();
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public Map getMap() {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.getMap();
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public Object getRandomKey() {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.getRandomKey();
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public boolean replace(Object key, Object expectedValue, Object newValue) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmimap.replace(key, expectedValue, newValue);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI map: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }
}

