/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.MasterProxyIF;
import hydra.RemoteTestModule;
import hydra.RmiRegistryHelper;
import hydra.blackboard.AnySharedCountersImpl;
import hydra.blackboard.AnySharedLockImpl;
import hydra.blackboard.AnySharedMapImpl;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public abstract class Blackboard {
    public static final int RMI = 0;
    public static final int GemFire = 1;
    private String name;
    private int type = -1;
    private LogWriter log;
    private SharedCounters sharedCounters;
    private String sharedCountersName;
    protected String[] counterNames;
    private static Map initialCounterValues = new HashMap();
    private SharedMap sharedMap;
    private String sharedMapName;
    private SharedLock sharedLock;
    private String sharedLockName;

    public Blackboard() {
    }

    public Blackboard(String name, String type, Class cls) {
        this(name, Blackboard.typeStringToInt(type), cls);
    }

    public Blackboard(String name, int type, Class cls) {
        this.name = name;
        this.sharedCountersName = name + "SharedCounters";
        this.sharedMapName = name + "SharedMap";
        this.sharedLockName = name + "SharedLock";
        this.type = type;
        this.log = Log.getLogWriter();
        Blackboard.setValues(cls, this);
    }

    public SharedCounters createSharedCounters(String name, String type, String[] cnames, long[] cvals) {
        this.counterNames = cnames;
        initialCounterValues.put(this.getClass(), cvals);
        SharedCounters sharedCounters = AnySharedCountersImpl.lookup(name + "SharedCounters", Blackboard.typeStringToInt(type));
        if (sharedCounters == null) {
            sharedCounters = AnySharedCountersImpl.bind(name + "SharedCounters", Blackboard.typeStringToInt(type), cvals);
        }
        return sharedCounters;
    }

    public SharedCounters getSharedCounters() {
        if (this.sharedCounters == null) {
            this.sharedCounters = AnySharedCountersImpl.lookup(this.sharedCountersName, this.type);
            if (this.sharedCounters == null) {
                String classname = this.getClass().getName();
                String methodname = "createSharedCounters";
                long[] initValues = (long[])initialCounterValues.get(this.getClass());
                Class[] types = new Class[]{String.class, String.class, String[].class, long[].class};
                Object[] args = new Object[]{this.name, Blackboard.typeIntToString(this.type), this.counterNames, initValues};
                this.invoke(classname, methodname, types, args);
            }
            this.sharedCounters = AnySharedCountersImpl.lookup(this.sharedCountersName, this.type);
        }
        return this.sharedCounters;
    }

    public int getSharedCounter(String sharedCounterName) {
        for (int i = 0; i < this.counterNames.length; ++i) {
            String name = this.counterNames[i];
            if (!name.equals(sharedCounterName)) continue;
            return i;
        }
        throw new HydraRuntimeException("Unable to find shared counter with name " + sharedCounterName);
    }

    public void printSharedCounters() {
        long[] counterValues = this.getSharedCounters().getCounterValues();
        if (counterValues.length != this.counterNames.length) {
            throw new IllegalArgumentException("Number of names not equal to number of counters");
        }
        StringBuffer buf = new StringBuffer(counterValues.length * 20);
        buf.append(this.name).append("SharedCounters:").append("\n");
        for (int i = 0; i < counterValues.length; ++i) {
            String name = this.counterNames[i];
            if (name == null) {
                throw new IllegalArgumentException("Null counter name at index " + i);
            }
            buf.append(" ").append(name).append("=").append(counterValues[i]).append("\n");
        }
        this.log.info(buf.toString());
    }

    public SharedMap createSharedMap(String name, String type) {
        SharedMap sharedMap = AnySharedMapImpl.lookup(name + "SharedMap", Blackboard.typeStringToInt(type));
        if (sharedMap == null) {
            sharedMap = AnySharedMapImpl.bind(name + "SharedMap", Blackboard.typeStringToInt(type));
        }
        return sharedMap;
    }

    public void print() {
        this.printSharedCounters();
        this.printSharedMap();
    }

    public SharedMap getSharedMap() {
        if (this.sharedMap == null) {
            this.sharedMap = AnySharedMapImpl.lookup(this.sharedMapName, this.type);
            if (this.sharedMap == null) {
                String classname = this.getClass().getName();
                String methodname = "createSharedMap";
                Class[] types = new Class[]{String.class, String.class};
                Object[] args = new Object[]{this.name, Blackboard.typeIntToString(this.type)};
                try {
                    if (RemoteTestModule.Master == null) {
                        MasterController.invoke(classname, methodname, types, args);
                    } else {
                        RemoteTestModule.Master.invoke(classname, methodname, types, args);
                    }
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to invoke " + classname + "." + methodname, e);
                }
            }
            this.sharedMap = AnySharedMapImpl.lookup(this.sharedMapName, this.type);
        }
        return this.sharedMap;
    }

    public void printSharedMap() {
        Map map = this.getSharedMap().getMap();
        StringBuffer buf = new StringBuffer(map.size() * 20);
        buf.append(this.name).append("SharedMap:");
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            buf.append(" ").append(key).append("=").append(val).append('\n');
        }
        this.log.info(buf.toString());
    }

    private static int typeStringToInt(String type) {
        if (type.equalsIgnoreCase("RMI")) {
            return 0;
        }
        if (type.equalsIgnoreCase("GemFire")) {
            return 1;
        }
        throw new IllegalArgumentException("Illegal transport type: " + type);
    }

    private static String typeIntToString(int type) {
        switch (type) {
            case 0: {
                return "RMI";
            }
            case 1: {
                return "Gemfire";
            }
        }
        throw new IllegalArgumentException("Illegal transport type: " + type);
    }

    private static synchronized void setValues(Class cls, Blackboard bb) {
        int m;
        int counternum = 0;
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String fieldname = fields[i].getName();
            if (fields[i].getDeclaringClass() != cls) {
                throw new HydraInternalException("Unexpected declarer");
            }
            if (fields[i].getType() != Integer.TYPE || !Modifier.isPublic(m = fields[i].getModifiers()) || !Modifier.isStatic(m)) continue;
            fields[i].setAccessible(true);
            ++counternum;
        }
        bb.counterNames = new String[counternum];
        long[] initValues = new long[counternum];
        counternum = 0;
        for (int i = 0; i < fields.length; ++i) {
            long value;
            if (fields[i].getType() != Integer.TYPE || !Modifier.isPublic(m = fields[i].getModifiers()) || !Modifier.isStatic(m)) continue;
            try {
                value = fields[i].getLong(null);
                bb.counterNames[counternum] = fields[i].getName();
                fields[i].setInt(null, counternum);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new HydraRuntimeException("Error accessing field", e);
            }
            initValues[counternum] = fields[i].getName().startsWith("Max") ? Long.MIN_VALUE : (fields[i].getName().startsWith("Min") ? Long.MAX_VALUE : value);
            ++counternum;
        }
        if (!initialCounterValues.containsKey(cls)) {
            initialCounterValues.put(cls, initValues);
        }
    }

    public String[] getCounterNames() {
        return this.counterNames;
    }

    public SharedLock createSharedLock(String name, String type) {
        SharedLock sharedLock = AnySharedLockImpl.lookup(name + "SharedLock", Blackboard.typeStringToInt(type));
        if (sharedLock == null) {
            sharedLock = AnySharedLockImpl.bind(name + "SharedLock", Blackboard.typeStringToInt(type));
        }
        return sharedLock;
    }

    public SharedLock getSharedLock() {
        if (this.sharedLock == null) {
            this.sharedLock = AnySharedLockImpl.lookup(this.sharedLockName, this.type);
            if (this.sharedLock == null) {
                String classname = this.getClass().getName();
                String methodname = "createSharedLock";
                Class[] types = new Class[]{String.class, String.class};
                Object[] args = new Object[]{this.name, Blackboard.typeIntToString(this.type)};
                try {
                    if (RemoteTestModule.Master == null) {
                        MasterController.invoke(classname, methodname, types, args);
                    } else {
                        RemoteTestModule.Master.invoke(classname, methodname, types, args);
                    }
                }
                catch (RemoteException e) {
                    String s = "Unable to invoke " + classname + "." + methodname;
                    throw new HydraRuntimeException(s, e);
                }
            }
            this.sharedLock = AnySharedLockImpl.lookup(this.sharedLockName, this.type);
        }
        return this.sharedLock;
    }

    private void invoke(String classname, String methodname, Class[] types, Object[] args) {
        try {
            MasterProxyIF master = RemoteTestModule.Master;
            if (master == null) {
                master = RmiRegistryHelper.lookupMaster();
            }
            master.invoke(classname, methodname, types, args);
        }
        catch (RemoteException e) {
            String s = "Unable to invoke " + classname + "." + methodname;
            throw new HydraRuntimeException(s, e);
        }
    }
}

