/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RmiRegistryHelper;
import hydra.blackboard.RmiSharedCondition;
import hydra.blackboard.RmiSharedLock;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;

public class RmiSharedLockImpl
extends UnicastRemoteObject
implements RmiSharedLock {
    private String ownerName = null;
    private int ownerVmid = -1;
    private long ownerTid = -1L;
    private int lockval = 0;
    private Map conditions = new HashMap(1);

    protected static void bind(String name, RmiSharedLock value) {
        RmiRegistryHelper.bindInMaster(name, value);
        if (RmiSharedLockImpl.log().finerEnabled()) {
            RmiSharedLockImpl.log().finer("Bound " + name + "=" + value + " into master registry");
        }
    }

    protected static RmiSharedLock lookup(String name) throws RemoteException {
        if (RmiSharedLockImpl.log().finerEnabled()) {
            RmiSharedLockImpl.log().finer("Looking up " + name + " in master registry");
        }
        return (RmiSharedLock)RmiRegistryHelper.lookupInMaster(name);
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    @Override
    public void lock(String name, int vmid, long tid) throws RemoteException {
        RmiSharedLockImpl rmiSharedLockImpl = this;
        synchronized (rmiSharedLockImpl) {
            if (this.lockval == 0) {
                this.ownerName = name;
                this.ownerVmid = vmid;
                this.ownerTid = tid;
                this.lockval = 1;
                return;
            }
            if (this.ownerVmid == vmid && this.ownerTid == tid && this.ownerName != null && this.ownerName.equals(name)) {
                String s = this.ownerName + " with vmid=" + this.ownerVmid + " tid=" + this.ownerTid + " already unlocked lock";
                throw new HydraRuntimeException(s);
            }
            boolean wasInterrupted = Thread.interrupted();
            try {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                    if (this.lockval != 0) continue;
                    this.ownerName = name;
                    this.ownerVmid = vmid;
                    this.ownerTid = tid;
                    this.lockval = 1;
                    return;
                } while (this.ownerVmid != vmid || this.ownerTid != tid || this.ownerName == null || !this.ownerName.equals(name));
                String s = this.ownerName + " with vmid=" + this.ownerVmid + " tid=" + this.ownerTid + " already locked lock";
                throw new HydraRuntimeException(s);
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public synchronized void unlock(String name, int vmid, long tid) throws RemoteException {
        if (this.ownerVmid == vmid && this.ownerTid == tid && this.ownerName != null && this.ownerName.equals(name)) {
            if (this.lockval != 1) {
                String s = this.ownerName + " with vmid=" + this.ownerVmid + " tid=" + this.ownerTid + " already unlocked lock";
                throw new HydraRuntimeException(s);
            }
        } else {
            String s = "Not lock owner, it is owned by " + this.ownerName + " with vmid=" + this.ownerVmid + " tid=" + this.ownerTid;
            throw new HydraRuntimeException(s);
        }
        this.ownerName = null;
        this.ownerVmid = -1;
        this.ownerTid = -1L;
        this.lockval = 0;
        this.notify();
    }

    @Override
    public synchronized RmiSharedCondition getCondition(String name) throws RemoteException {
        RmiSharedCondition condition = (RmiSharedCondition)this.conditions.get(name);
        if (condition == null) {
            condition = new RmiSharedConditionImpl();
            this.conditions.put(name, condition);
        }
        return condition;
    }

    private class RmiSharedConditionImpl
    extends UnicastRemoteObject
    implements RmiSharedCondition {
        private static final long serialVersionUID = 8493062817798851101L;

        protected RmiSharedConditionImpl() throws RemoteException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await(String name, int vmid, long tid) throws RemoteException, InterruptedException {
            if (RmiSharedLockImpl.this.ownerVmid != vmid || RmiSharedLockImpl.this.ownerTid != tid || RmiSharedLockImpl.this.ownerName != null && !RmiSharedLockImpl.this.ownerName.equals(name)) {
                String s = "Not lock owner, it is owned by " + RmiSharedLockImpl.this.ownerName + " with vmid=" + RmiSharedLockImpl.this.ownerVmid + " tid=" + RmiSharedLockImpl.this.ownerTid;
                throw new HydraRuntimeException(s);
            }
            RmiSharedConditionImpl rmiSharedConditionImpl = this;
            synchronized (rmiSharedConditionImpl) {
                RmiSharedLockImpl.this.unlock(name, vmid, tid);
                this.wait();
            }
            RmiSharedLockImpl.this.lock(name, vmid, tid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signal(String name, int vmid, long tid) throws RemoteException {
            if (RmiSharedLockImpl.this.ownerVmid != vmid || RmiSharedLockImpl.this.ownerTid != tid || RmiSharedLockImpl.this.ownerName != null && !RmiSharedLockImpl.this.ownerName.equals(name)) {
                String s = "Not lock owner, it is owned by " + RmiSharedLockImpl.this.ownerName + " with vmid=" + RmiSharedLockImpl.this.ownerVmid + " tid=" + RmiSharedLockImpl.this.ownerTid;
                throw new HydraRuntimeException(s);
            }
            RmiSharedConditionImpl rmiSharedConditionImpl = this;
            synchronized (rmiSharedConditionImpl) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signalAll(String name, int vmid, long tid) throws RemoteException {
            if (RmiSharedLockImpl.this.ownerVmid != vmid || RmiSharedLockImpl.this.ownerTid != tid || RmiSharedLockImpl.this.ownerName != null && !RmiSharedLockImpl.this.ownerName.equals(name)) {
                String s = "Not lock owner, it is owned by " + RmiSharedLockImpl.this.ownerName + " with vmid=" + RmiSharedLockImpl.this.ownerVmid + " tid=" + RmiSharedLockImpl.this.ownerTid;
                throw new HydraRuntimeException(s);
            }
            RmiSharedConditionImpl rmiSharedConditionImpl = this;
            synchronized (rmiSharedConditionImpl) {
                this.notifyAll();
            }
        }
    }
}

