/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.Assert;
import hydra.GsRandom;
import hydra.Log;
import hydra.RmiRegistryHelper;
import hydra.TestConfig;
import hydra.blackboard.RmiSharedMap;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Map;

public class RmiSharedMapImpl
extends UnicastRemoteObject
implements RmiSharedMap {
    private Map map = new Hashtable();

    protected static void bind(String name, RmiSharedMap value) {
        RmiRegistryHelper.bindInMaster(name, value);
        if (RmiSharedMapImpl.log().finerEnabled()) {
            RmiSharedMapImpl.log().finer("Bound " + name + "=" + value + " into master registry");
        }
    }

    protected static RmiSharedMap lookup(String name) throws RemoteException {
        if (RmiSharedMapImpl.log().finerEnabled()) {
            RmiSharedMapImpl.log().finer("Looking up " + name + " in master registry");
        }
        return (RmiSharedMap)RmiRegistryHelper.lookupInMaster(name);
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    @Override
    public int size() throws RemoteException {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() throws RemoteException {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) throws RemoteException {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) throws RemoteException {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) throws RemoteException {
        return this.map.get(key);
    }

    @Override
    public Object put(Object key, Object value) throws RemoteException {
        return this.map.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long putIfLarger(Object key, long value) throws RemoteException {
        Map map = this.map;
        synchronized (map) {
            Long current = (Long)this.map.get(key);
            if (current == null || current < value) {
                this.map.put(key, new Long(value));
                return value;
            }
            return current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long putIfSmaller(Object key, long value) throws RemoteException {
        Map map = this.map;
        synchronized (map) {
            Long current = (Long)this.map.get(key);
            if (current == null || current > value) {
                this.map.put(key, new Long(value));
                return value;
            }
            return current;
        }
    }

    @Override
    public Object remove(Object key) throws RemoteException {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map t) throws RemoteException {
        this.map.putAll(t);
    }

    @Override
    public void clear() throws RemoteException {
        this.map.clear();
    }

    @Override
    public Map getMap() throws RemoteException {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRandomKey() throws RemoteException {
        GsRandom random = TestConfig.tab().getRandGen();
        Map map = this.map;
        synchronized (map) {
            if (this.map.size() == 0) {
                return null;
            }
            Object[] array = this.map.keySet().toArray();
            Assert.assertTrue((array.length == this.map.size() ? 1 : 0) != 0);
            int index = random.nextInt(array.length - 1);
            if (index >= array.length) {
                Assert.assertTrue((boolean)false, (Object)("Index is " + index + ", but array length is " + array.length));
            }
            return array[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, Object expectedValue, Object newValue) throws RemoteException {
        Map map = this.map;
        synchronized (map) {
            Object currentValue = this.map.get(key);
            if (currentValue == null) {
                if (expectedValue != null) {
                    return false;
                }
            } else if (!currentValue.equals(expectedValue)) {
                return false;
            }
            this.map.put(key, newValue);
            return true;
        }
    }
}

