/*
 * Decompiled with CFR 0.152.
 */
package hydra.log;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class CircularOutputStream
extends OutputStream {
    private static byte marker = (byte)37;
    String name;
    int maxBytes;
    boolean rolling = false;
    RandomAccessFile raf;

    public CircularOutputStream(String name, int maxBytes) throws IOException {
        this.name = name;
        this.maxBytes = maxBytes;
        this.rolling = maxBytes > 0;
        try {
            this.raf = new RandomAccessFile(name, "rw");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IOException("Unable to create stream named " + name);
        }
        if (this.rolling) {
            this.raf.write(marker);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.rolling) {
            long fptr = this.raf.getFilePointer() - 1L;
            this.raf.seek(fptr);
            int space = (int)((long)this.maxBytes - fptr);
            if (len <= space) {
                this.raf.write(b, off, len);
            } else {
                this.raf.write(b, off, space);
                this.raf.seek(0L);
                this.raf.write(b, off + space, len - space);
            }
            if (this.raf.getFilePointer() == (long)this.maxBytes) {
                this.raf.seek(0L);
            }
            this.raf.write(marker);
        } else {
            this.raf.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        long fptr = this.raf.getFilePointer() - 1L;
        this.raf.seek(fptr);
        this.raf.writeByte(b);
        if (this.raf.getFilePointer() == (long)this.maxBytes) {
            this.raf.seek(0L);
        }
        this.raf.write(marker);
    }

    public static void main(String[] args) throws IOException {
        CircularOutputStream t = new CircularOutputStream("frip", 10);
        PrintStream ps = new PrintStream(t, true);
        System.setOut(ps);
        System.setErr(ps);
        System.out.println("WHERE WILL THIS GO?");
        String s = "AND WHAT ABOUT THIS?\n";
        t.write(s.getBytes());
    }
}

