/*
 * Decompiled with CFR 0.152.
 */
package hydra.log;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.LogWriterImpl;
import hydra.HydraRuntimeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LogProcessOutputReader {
    private int exitCode;

    public LogProcessOutputReader(Process p, final LogWriter log, final String levelName, String prefix) {
        final int level = LogWriterImpl.levelNameToCode((String)levelName);
        final String pre = prefix == null ? "" : prefix;
        class ProcessStreamReader
        extends Thread {
            private BufferedReader reader;
            public int linecount = 0;

            public ProcessStreamReader(InputStream stream) {
                this.reader = new BufferedReader(new InputStreamReader(stream));
            }

            @Override
            public void run() {
                try {
                    String line;
                    block11: while ((line = this.reader.readLine()) != null) {
                        ++this.linecount;
                        switch (level) {
                            case 300: {
                                log.finest(pre + line);
                                continue block11;
                            }
                            case 400: {
                                log.finer(pre + line);
                                continue block11;
                            }
                            case 500: {
                                log.fine(pre + line);
                                continue block11;
                            }
                            case 700: {
                                log.config(pre + line);
                                continue block11;
                            }
                            case 800: {
                                log.info(pre + line);
                                continue block11;
                            }
                            case 900: {
                                log.warning(pre + line);
                                continue block11;
                            }
                            case 1000: {
                                log.severe(pre + line);
                                continue block11;
                            }
                        }
                        throw new HydraRuntimeException("Illegal level to log at: " + levelName);
                    }
                    this.reader.close();
                }
                catch (Exception e) {
                    System.out.println("Uncaught exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        ProcessStreamReader stdout = new ProcessStreamReader(p.getInputStream());
        ProcessStreamReader stderr = new ProcessStreamReader(p.getErrorStream());
        stdout.start();
        stderr.start();
        try {
            stderr.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stdout.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exitCode = 0;
        int retryCount = 9;
        while (retryCount > 0) {
            --retryCount;
            try {
                this.exitCode = p.exitValue();
                break;
            }
            catch (IllegalThreadStateException e) {
                if (retryCount == 0) {
                    if (stderr.linecount <= 0) continue;
                    log.warning("Failed to get exit status and it wrote to stderr so setting exit status to 1.");
                    this.exitCode = 1;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

