/*
 * Decompiled with CFR 0.152.
 */
package hydra.samples;

import com.gemstone.gemfire.LogWriter;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import hydra.samples.SampleBlackboard;
import java.util.HashMap;

public class BBClient {
    public static void worktask() {
        BBClient c = new BBClient();
        c.work();
    }

    private void work() {
        SampleBlackboard blackboard = SampleBlackboard.getInstance();
        SharedCounters counters = blackboard.getSharedCounters();
        counters.increment(SampleBlackboard.MiscInt);
        SharedMap map = blackboard.getSharedMap();
        long uid = counters.incrementAndRead(SampleBlackboard.NextUniqueID);
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        String client = "client" + tid;
        map.put(new Integer(tid), client);
        HashMap<String, Integer> frip = new HashMap<String, Integer>();
        frip.put(client, new Integer(1000 * tid));
        map.put(client, frip);
        this.log().info("MAP: Put " + uid + "=" + client);
    }

    public static void printtask() {
        SampleBlackboard blackboard = SampleBlackboard.getInstance();
        blackboard.print();
    }

    private LogWriter log() {
        return Log.getLogWriter();
    }
}

