/*
 * Decompiled with CFR 0.152.
 */
package hydra.samples;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import hydra.samples.DistBlackboard;
import hydra.samples.SampleTestException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import util.CacheUtil;

public class DistClient {
    private static final String DATA_KEY = "Austin";
    private static final String REGION_NAME = "Texas";

    public static synchronized void createCacheTask() {
        if (CacheUtil.getCache() == null) {
            DistClient.log().info("Initializing the cache");
            CacheUtil.createCache();
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setRegionTimeToLive(ExpirationAttributes.DEFAULT);
            factory.setEntryTimeToLive(ExpirationAttributes.DEFAULT);
            RegionAttributes ratts = factory.createRegionAttributes();
            CacheUtil.createRegion(REGION_NAME, ratts);
            DistClient.log().info("Initialized the cache");
        }
    }

    public static synchronized void closeCacheTask() {
        if (CacheUtil.getCache() != null) {
            DistClient.log().info("Closing the cache");
            CacheUtil.closeCache();
            DistClient.log().info("Closed the cache");
        }
    }

    public static void initCacheTask() {
        DistClient dc = new DistClient();
        dc.initdata();
    }

    public static void updateTask() {
        DistClient dc = new DistClient();
        dc.update();
    }

    public static void atomicUpdateTask() {
        DistClient dc = new DistClient();
        dc.atomicUpdate();
    }

    public static void readTask() {
        DistClient dc = new DistClient();
        dc.read();
    }

    public static synchronized void checkDistributedCacheTask() {
        DistClient dc = new DistClient();
        dc.checkdata();
    }

    private Region getRegionOfInterest() {
        return CacheUtil.getRegion(REGION_NAME);
    }

    private void initdata() {
        DistClient.log().info("Initializing data");
        Region region = this.getRegionOfInterest();
        try {
            DistClient.log().info("Initializing " + this.logstr(region, DATA_KEY));
            Integer inVal = new Integer(0);
            region.put((Object)DATA_KEY, (Object)inVal);
            DistClient.log().info("Initialized " + this.logstr(region, DATA_KEY));
            Integer outVal = (Integer)region.get((Object)DATA_KEY);
            DistClient.log().info("Got " + this.logstr(region, DATA_KEY, outVal));
            if (!outVal.equals(inVal)) {
                throw new SampleTestException("Put " + inVal + " in cache, but got " + outVal);
            }
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Cache exception", e);
        }
        DistClient.log().info("Initialized data");
    }

    private void checkdata() {
        Region region = this.getRegionOfInterest();
        DistClient.log().info("Checking " + this.logstr(region, DATA_KEY));
        SharedCounters counters = DistBlackboard.getInstance().getSharedCounters();
        long writes = counters.read(DistBlackboard.NumWrites);
        Integer val = (Integer)this.readData(region, DATA_KEY);
        if ((long)val.intValue() != writes) {
            throw new SampleTestException("Expected " + writes + " but got " + this.logstr(region, DATA_KEY, val));
        }
        DistClient.log().info("Checked " + this.logstr(region, DATA_KEY));
    }

    private void update() {
        Region region = this.getRegionOfInterest();
        Integer oldVal = (Integer)this.readData(region, DATA_KEY);
        Integer newVal = new Integer(oldVal + 1);
        this.updateData(region, DATA_KEY, newVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomicUpdate() {
        boolean locked;
        Region region = this.getRegionOfInterest();
        Lock lock = region.getDistributedLock((Object)DATA_KEY);
        try {
            locked = lock.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            String s = "Interrupted getting ownership of Austin, " + region.getName();
            throw new SampleTestException(s, e);
        }
        if (locked) {
            try {
                this.update();
            }
            finally {
                lock.unlock();
            }
        } else {
            String s = "Timed out getting ownership of Austin, " + region.getName();
            throw new SampleTestException(s);
        }
    }

    private void read() {
        Region region = this.getRegionOfInterest();
        this.readData(region, DATA_KEY);
    }

    private Object readData(Region region, Object key) {
        Object val = null;
        try {
            val = region.get(key);
            DistClient.log().info("Read " + this.logstr(region, key, val));
        }
        catch (Exception e) {
            throw new SampleTestException("Problem reading " + key, e);
        }
        SharedCounters counters = DistBlackboard.getInstance().getSharedCounters();
        counters.increment(DistBlackboard.NumReads);
        return val;
    }

    private void updateData(Region region, Object key, Object val) {
        try {
            region.put(key, val);
            DistClient.log().info("Wrote " + this.logstr(region, key, val));
        }
        catch (Exception e) {
            throw new SampleTestException("Problem writing " + key, e);
        }
        SharedCounters counters = DistBlackboard.getInstance().getSharedCounters();
        counters.increment(DistBlackboard.NumWrites);
    }

    private String logstr(Region region, Object key) {
        return region.getFullPath() + "/" + key;
    }

    private String logstr(Region region, Object key, Object val) {
        return this.logstr(region, key) + " ==> " + val;
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

