/*
 * Decompiled with CFR 0.152.
 */
package hydra.timeserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class TimeRequest {
    private final byte packetId;
    private final boolean isNanoTime;

    public TimeRequest(byte packetId, boolean isNanoTime) {
        this.packetId = packetId;
        this.isNanoTime = isNanoTime;
    }

    public byte getPacketId() {
        return this.packetId;
    }

    public boolean isNanoTime() {
        return this.isNanoTime;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(ba);
        try {
            dataOut.writeByte(this.packetId);
            dataOut.writeBoolean(this.isNanoTime);
            dataOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("ByteArrayOutputStream will not throw an IOException");
        }
        return ba.toByteArray();
    }

    public static TimeRequest fromByteArray(byte[] bytes) throws IOException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        DataInputStream dataIn = new DataInputStream(bi);
        byte packetId = dataIn.readByte();
        boolean isNanoTime = dataIn.readBoolean();
        return new TimeRequest(packetId, isNanoTime);
    }
}

