/*
 * Decompiled with CFR 0.152.
 */
package hydra.training;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RmiRegistryHelper;
import hydra.training.QueueElement;
import hydra.training.RBQBlackboard;
import hydra.training.RBQPrms;
import hydra.training.RemoteBlockingQueue;
import hydra.training.RemoteBlockingQueueImpl;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import util.TestException;

public class RBQTasks {
    private static final String QUEUE_NAME = "queue";
    private static final Map sequenceNumbers = new HashMap();

    public static void initialize() {
        if (!RBQPrms.useBlackboard()) {
            String s = "This test is not configured to use the blackboard";
            throw new HydraConfigException(s);
        }
        RBQBlackboard bb = RBQBlackboard.getBB();
        bb.initializeCapacity();
        LogWriter log = Log.getLogWriter();
        log.info("Initial value of RBQBlackboard.MinOfferTime: " + bb.getMinOfferTime());
        log.info("Initial value of RBQBlackboard.MaxOfferTime: " + bb.getMaxOfferTime());
        log.info("Initial value of RBQBlackboard.MinPollTime: " + bb.getMinPollTime());
        log.info("Initial value of RBQBlackboard.MaxPollTime: " + bb.getMaxPollTime());
        log.info("Initial value of RBQBlackboard.NumOffers: " + bb.getNumOffers());
        log.info("Initial value of RBQBlackboard.NumPolls: " + bb.getNumPolls());
        log.info("Initial value of RBQBlackboard.MyCounter: " + bb.getMyCounter());
    }

    public static void bindRBQ() throws RemoteException {
        int capacity = RBQPrms.useBlackboard() ? RBQBlackboard.getBB().getQueueCapacity() : RBQPrms.getQueueCapacity();
        Log.getLogWriter().info("Creating RemoteBlockingQueueImpl with capacity " + capacity);
        RemoteBlockingQueueImpl rbq = new RemoteBlockingQueueImpl(capacity);
        try {
            RmiRegistryHelper.bindInMaster(QUEUE_NAME, rbq);
        }
        catch (HydraRuntimeException ex) {
            if (ex.getCause() instanceof AlreadyBoundException) {
                return;
            }
            throw ex;
        }
    }

    private static RemoteBlockingQueue getQueue() {
        return (RemoteBlockingQueue)RmiRegistryHelper.lookupInMaster(QUEUE_NAME);
    }

    public static void populate() throws RemoteException, InterruptedException {
        RemoteBlockingQueue queue = RBQTasks.getQueue();
        NanoTimer timer = new NanoTimer();
        for (int i = 0; i < 500; ++i) {
            QueueElement element = new QueueElement();
            if (RBQPrms.debug()) {
                Log.getLogWriter().info("Offering " + element);
            }
            timer.reset();
            queue.offer(element, Integer.MAX_VALUE, TimeUnit.SECONDS);
            long duration = timer.reset();
            if (!RBQPrms.useBlackboard()) continue;
            RBQBlackboard.getBB().noteOffer(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void consume() throws RemoteException, InterruptedException {
        RemoteBlockingQueue queue = RBQTasks.getQueue();
        NanoTimer timer = new NanoTimer();
        while (true) {
            String threadName;
            int[] prevSeqNum;
            Map map = sequenceNumbers;
            // MONITORENTER : map
            timer.reset();
            QueueElement element = (QueueElement)queue.poll(30L, TimeUnit.SECONDS);
            long duration = timer.reset();
            if (RBQPrms.debug()) {
                Log.getLogWriter().info("Removed " + element);
            }
            if (element == null) {
                // MONITOREXIT : map
                return;
            }
            if (RBQPrms.useBlackboard()) {
                RBQBlackboard.getBB().notePoll(duration);
            }
            if ((prevSeqNum = (int[])sequenceNumbers.get(threadName = element.getThreadName())) == null) {
                prevSeqNum = new int[]{-1};
                sequenceNumbers.put(threadName, prevSeqNum);
            }
            int seqNum = element.getSequenceNumber();
            int[] nArray = prevSeqNum;
            // MONITORENTER : prevSeqNum
            if (seqNum <= prevSeqNum[0]) {
                String s = "Element " + seqNum + " from client thread " + threadName + " should not come after " + prevSeqNum[0];
                throw new TestException(s);
            }
            prevSeqNum[0] = seqNum;
            // MONITOREXIT : nArray
            // MONITOREXIT : map
        }
    }

    public static void validate() throws RemoteException {
        RBQBlackboard bb = RBQBlackboard.getBB();
        bb.print();
        long minOfferTime = bb.getMinOfferTime();
        long maxOfferTime = bb.getMaxOfferTime();
        long minPollTime = bb.getMinPollTime();
        long maxPollTime = bb.getMaxPollTime();
        LogWriter log = Log.getLogWriter();
        log.info("Minimum time for offer: " + minOfferTime + " nanos");
        log.info("Maximum time for offer: " + maxOfferTime + " nanos");
        log.info("Minimum time for poll : " + minPollTime + " nanos");
        log.info("Maximum time for poll : " + maxPollTime + " nanos");
        long numPolls = bb.getNumPolls();
        long numOffers = bb.getNumOffers();
        if (numPolls != numOffers) {
            String s = "Expected number of poll operations " + numPolls + " to equal number of offer operations " + numOffers;
            throw new TestException(s);
        }
    }

    public static void jprobeEntry() {
        Log.getLogWriter().info("Begin JProbe measurement");
    }

    public static void jprobeExit() {
        Log.getLogWriter().info("End JProbe measurement");
    }
}

