/*
 * Decompiled with CFR 0.152.
 */
package hydratest.disconnect;

import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydratest.disconnect.DisconnectPrms;

public class DisconnectClient {
    public static final String REGION_NAME = "region";
    public static HydraThreadLocal localregion = new HydraThreadLocal();

    public static void startLocatorTask() {
        DistributedSystemHelper.createLocator();
        DistributedSystemHelper.startLocatorAndDS();
    }

    public static void connectTask() {
        DistributedSystemHelper.connect();
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Region region = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        localregion.set(region);
    }

    public static void disconnectTask() throws ClientVmNotFoundException {
        MasterController.sleepForMs(5000);
        String clientName = TestConfig.tab().stringAt(DisconnectPrms.clientName);
        if (TestConfig.tab().booleanAt(DisconnectPrms.onDemand)) {
            ClientVmInfo info = ClientVmMgr.stop("testing synchronous disconnect using client name", -24, -31, new ClientVmInfo(null, clientName, null));
            MasterController.sleepForMs(11000);
            ClientVmInfo clientVmInfo = ClientVmMgr.start("testing synchronous reconnect using client vm info", info);
        } else {
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("testing synchronous disconnect using client name", -24, -30, new ClientVmInfo(null, clientName, null));
        }
    }

    public static void putTask() {
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        Region region = (Region)localregion.get();
        long end = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < end) {
            region.put((Object)tid, (Object)tid);
        }
    }

    public static void logTask() {
        Log.getLogWriter().info("LOG TASK");
    }
}

