/*
 * Decompiled with CFR 0.152.
 */
package hydratest.grid;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydratest.grid.GridPrms;
import java.util.Set;

public class GridClient {
    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startLocatorAndAdminDSTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void generateCacheXmlTask() {
        String cacheXmlFile = GridClient.getCacheXmlFile();
        DistributedSystemHelper.connectWithXml(cacheXmlFile);
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), null, ConfigPrms.getRegionConfig(), null, ConfigPrms.getBridgeConfig(), ConfigPrms.getPoolConfig(), ConfigPrms.getDiskStoreConfig(), ConfigPrms.getGatewaySenderConfig(), ConfigPrms.getGatewayReceiverConfig(), ConfigPrms.getAsyncEventQueueConfig(), null, cacheXmlFile);
    }

    public static void generateCacheXmlFcnTask() {
        String cacheXmlFile = GridClient.getCacheXmlFile();
        DistributedSystemHelper.connectWithXml(cacheXmlFile);
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), null, ConfigPrms.getRegionConfig(), null, ConfigPrms.getBridgeConfig(), ConfigPrms.getPoolConfig(), ConfigPrms.getDiskStoreConfig(), GridPrms.getFunctions(), cacheXmlFile);
    }

    public static void generateCacheXmlMultiTask() {
        String cacheXmlFile = GridClient.getCacheXmlFile();
        DistributedSystemHelper.connectWithXml(cacheXmlFile);
        CacheHelper.generateCacheXmlFileNoCheck(ConfigPrms.getCacheConfig(), null, GridPrms.getRegionConfigs(), null, ConfigPrms.getBridgeConfig(), GridPrms.getPoolConfigs(), cacheXmlFile);
    }

    public static void openCacheWithXmlTask() {
        String cacheXmlFile = GridClient.getCacheXmlFile();
        Cache cache = CacheHelper.createCacheFromXml(cacheXmlFile);
        Region region = RegionHelper.getRegion("DefaultRegion");
        Log.getLogWriter().info("Created region DefaultRegion with region attributes " + RegionHelper.regionAttributesToString(region.getAttributes()));
    }

    public static void openCacheWithXmlMultiTask() {
        String cacheXmlFile = GridClient.getCacheXmlFile();
        Cache cache = CacheHelper.createCacheFromXml(cacheXmlFile);
        Set regions = CacheHelper.getCache().rootRegions();
        for (Region region : regions) {
            Log.getLogWriter().info("Created region " + region.getName() + " with region attributes " + RegionHelper.regionAttributesToString(region.getAttributes()));
        }
    }

    public static void putDataTask() {
        Region r = RegionHelper.getRegion("DefaultRegion");
        for (int i = 0; i < 10000; ++i) {
            r.put((Object)new Integer(i), (Object)new Integer(i));
        }
    }

    public static void putDataMultiTask() {
        Set regions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Putting data in regions: " + regions);
        for (int i = 0; i < 10000; ++i) {
            for (Region region : regions) {
                region.put((Object)new Integer(i), (Object)new Integer(i));
            }
        }
    }

    private static String getCacheXmlFile() {
        return System.getProperty("user.dir") + "/" + "vm_" + RemoteTestModule.getMyVmid() + "_" + System.getProperty("clientName") + ".xml";
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }
}

