/*
 * Decompiled with CFR 0.152.
 */
package hydratest.hydracheck;

import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydratest.hydracheck.HydraCheckPrms;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import util.CacheUtil;

public class HydraCheckClient {
    public static void validateJDKVersion() {
        Log.getLogWriter().info("Checking JDK version");
        String expectedJDK = TestConfig.tab().stringAt(HydraCheckPrms.jdkVersion);
        String actualJDK = System.getProperty("java.version");
        if (!actualJDK.equals(expectedJDK)) {
            String s = "Expected JDK " + expectedJDK + ", found " + actualJDK;
            throw new HydraRuntimeException(s);
        }
        Log.getLogWriter().info("Checked JDK version is " + actualJDK);
    }

    public static void openCache() {
        CacheUtil.createCache();
        CacheUtil.createRegion("TestRegion");
        CacheUtil.closeCache();
    }

    public static void moveSystemDirectories() throws IOException {
        String line;
        Log.getLogWriter().info("Moving system directories");
        String cmd = System.getProperty("java.home") + "/bin/java " + "-classpath " + System.getProperty("java.class.path") + " hydra.TestFileUtil move sysdirs";
        String result = HydraCheckClient.execute(cmd);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        while ((line = reader.readLine()) != null) {
            if (result.startsWith("Moving")) continue;
            String s = "Problem moving system directory: " + line;
            throw new HydraRuntimeException(s);
        }
        reader.close();
        Log.getLogWriter().info("Moved system directories:\n" + result);
    }

    public static void grepForIssues() throws FileNotFoundException, IOException {
        Log.getLogWriter().info("Grepping for issues");
        String jtests = System.getProperty("JTESTS");
        String errs = null;
        try {
            errs = HydraCheckClient.execute(jtests + "/hydratest/hydracheck/grep.sh");
        }
        catch (HydraRuntimeException e) {
            if (e.getMessage().indexOf("Command failed with exit code: 1") == -1) {
                throw e;
            }
            Log.getLogWriter().info(e.getMessage());
        }
        String errlog = FileUtil.getText("errlog");
        if (errlog.length() > 0) {
            String s = "Found errors:\n" + errlog;
            throw new HydraRuntimeException(s);
        }
        Log.getLogWriter().info("Grepped for issues, found none");
    }

    private static String execute(String cmd) {
        Log.getLogWriter().info("Executing " + cmd);
        String result = ProcessMgr.fgexec(cmd, 300);
        Log.getLogWriter().info("Executed " + cmd);
        return result;
    }
}

