/*
 * Decompiled with CFR 0.152.
 */
package hydratest.reboot;

import hydra.ClientInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HadoopHelper;
import hydra.HostDescription;
import hydra.Log;
import hydra.MasterController;
import hydra.RebootHostNotFoundException;
import hydra.RebootInfo;
import hydra.RebootMgr;
import hydra.TestConfig;
import hydratest.reboot.RebootPrms;

public class RebootClient {
    public static void rebootTask() throws ClientVmNotFoundException, RebootHostNotFoundException {
        String logicalHost = RebootPrms.getLogicalHostToReboot();
        HostDescription hd = TestConfig.getInstance().getHostDescription(logicalHost);
        String host = hd.getHostName();
        Log.getLogWriter().info("Rebooting host " + host);
        RebootInfo info = RebootMgr.reboot("testing reboot", host, true);
        Log.getLogWriter().info("Rebooted host " + host);
        RebootMgr.clearInfo(host);
        Log.getLogWriter().info("Restarting hadoops: " + info.getHadoops());
        HadoopHelper.startHadoopProcesses(info.getHadoops());
        Log.getLogWriter().info("Restarted hadoops");
        Log.getLogWriter().info("Restarting clients: " + info.getClients());
        for (ClientInfo client : info.getClients()) {
            ClientVmMgr.start("testing client restart", client.getClientVmInfo());
        }
        Log.getLogWriter().info("Restarted clients");
        MasterController.sleepForMs(15000);
    }

    public static void workTask() {
        MasterController.sleepForMs(37000);
    }
}

