/*
 * Decompiled with CFR 0.152.
 */
package hydratest.security;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.security.AuthInitialize;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydratest.security.SecurityTestPrms;
import java.util.Properties;

public class UserPassword
implements AuthInitialize {
    private static long FirstUseTime = 0L;

    public static AuthInitialize create() {
        return new UserPassword();
    }

    public void init(LogWriter systemLogger, LogWriter securityLogger) throws AuthenticationFailedException {
    }

    public Properties getCredentials(Properties p, DistributedMember server, boolean isPeer) throws AuthenticationFailedException {
        if (Log.getLogWriter().fineEnabled()) {
            String s = "Test configured security properties: ";
            s = isPeer ? s + DistributedSystemHelper.getGemFireDescription().getSecurityDescription().getPeerExtraProperties() : s + DistributedSystemHelper.getGemFireDescription().getSecurityDescription().getClientExtraProperties();
            Log.getLogWriter().fine(s);
        }
        Log.getLogWriter().fine("Test got security properties: " + p);
        String username = p.getProperty("security-username");
        String password = null;
        if (SecurityTestPrms.useBogusPassword()) {
            password = "BogusPassword";
        } else {
            password = p.getProperty("security-password");
            if (password.equals("DefaultPassword")) {
                if (FirstUseTime == 0L) {
                    FirstUseTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - FirstUseTime > (long)(SecurityTestPrms.getExpireSeconds() * 1000)) {
                    String s = "Use of default password has expired, please reset";
                    Log.getLogWriter().info("AuthInitialize: " + s);
                    return null;
                }
                p.setProperty("security-password", password);
            }
        }
        Log.getLogWriter().info("AuthInitialize: set " + username + " " + password);
        return p;
    }

    public void close() {
        Log.getLogWriter().info("AuthInitialize: closed");
    }
}

