/*
 * Decompiled with CFR 0.152.
 */
package hydratest.stopstart;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.HydraInternalException;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydratest.stopstart.StopStartPrms;

public class StopStartClient {
    public static void stopDeadlockTask() throws ClientVmNotFoundException {
        try {
            ClientVmInfo info = ClientVmMgr.stop("testing deadlock detection", -23, -30);
            throw new HydraInternalException("Test failed to detect deadlock");
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().indexOf("deadlock") == -1) {
                throw e;
            }
            StopStartClient.log().info(e.getMessage());
            try {
                Integer vmid = new Integer(RemoteTestModule.getMyVmid());
                ClientVmInfo info = ClientVmMgr.stop("testing deadlock detection", -22, -32, new ClientVmInfo(vmid, null, null));
                throw new HydraInternalException("Test failed to detect deadlock");
            }
            catch (IllegalArgumentException e2) {
                if (e2.getMessage().indexOf("deadlock") == -1) {
                    throw e2;
                }
                StopStartClient.log().info(e2.getMessage());
                return;
            }
        }
    }

    public static void stopTask() throws ClientVmNotFoundException {
        ClientVmInfo info = ClientVmMgr.stop("testing synchronous mean kill on myself");
        String msg = "Test failed to do synchronous mean kill on me: " + info;
        throw new HydraInternalException(msg);
    }

    public static void stopRegExTask() throws ClientVmNotFoundException {
        String clientName = TestConfig.tab().stringAt(StopStartPrms.clientName);
        ClientVmInfo info = ClientVmMgr.stop("testing synchronous mean kill using client name", -21, -32, new ClientVmInfo(null, clientName, null));
    }

    public static void stopAsyncTask() throws ClientVmNotFoundException {
        ConfigHashtable tab = TestConfig.tab();
        long totalIterations = tab.longAt(StopStartPrms.totalIterations);
        long stopIteration = tab.longAt(StopStartPrms.stopIteration);
        int i = 0;
        while ((long)i < totalIterations) {
            StopStartClient.log().info("iteration: " + i);
            if ((long)i == stopIteration) {
                StopStartClient.log().info("invoking stopAsync");
                ClientVmInfo clientVmInfo = ClientVmMgr.stopAsync("stop iteration: " + stopIteration + " of " + totalIterations, -21, -30);
            }
            ++i;
        }
    }

    public static void stopVariousTask() throws ClientVmNotFoundException {
        ConfigHashtable tab = TestConfig.tab();
        int stopMode = ClientVmMgr.toStopMode(tab.stringAt(StopStartPrms.stopMode));
        int startMode = ClientVmMgr.toStartMode(tab.stringAt(StopStartPrms.startMode));
        ClientVmInfo info = ClientVmMgr.stop("testing synchronous stop on myself", stopMode, startMode);
        String msg = "Test failed to do synchronous stop on me: " + info;
        throw new HydraInternalException(msg);
    }

    public static void stopVariousAsyncTask() throws ClientVmNotFoundException {
        ConfigHashtable tab = TestConfig.tab();
        int stopMode = ClientVmMgr.toStopMode(tab.stringAt(StopStartPrms.stopMode));
        int startMode = ClientVmMgr.toStartMode(tab.stringAt(StopStartPrms.startMode));
        long totalIterations = tab.longAt(StopStartPrms.totalIterations);
        long stopIteration = tab.longAt(StopStartPrms.stopIteration);
        int i = 0;
        while ((long)i < totalIterations) {
            StopStartClient.log().info("iteration: " + i);
            if ((long)i == stopIteration) {
                StopStartClient.log().info("invoking stopAsync");
                ClientVmInfo clientVmInfo = ClientVmMgr.stopAsync("stop iteration: " + stopIteration + " of " + totalIterations, stopMode, startMode);
            }
            ++i;
        }
    }

    public static void startTask() throws ClientVmNotFoundException {
        while (true) {
            try {
                ClientVmInfo info = ClientVmMgr.start("testing synchronous start on any stopped vm");
                StopStartClient.log().info("This should appear after start has completed.");
            }
            catch (ClientVmNotFoundException e) {
                StopStartClient.log().info("No vm is available for start");
                MasterController.sleepForMs(250);
                continue;
            }
            break;
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

