/*
 * Decompiled with CFR 0.152.
 */
package hydratest.version.clientcache;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientRegionDescription;
import hydra.ClientRegionHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;

public class CacheClient {
    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void openClientCacheTask() {
        ClientCacheHelper.createCache(ConfigPrms.getClientCacheConfig());
    }

    public static void openClientCacheFromXmlTask() {
        String fn = "cache_" + RemoteTestModule.getMyVmid() + ".xml";
        ClientCacheHelper.generateCacheXmlFile(ConfigPrms.getClientCacheConfig(), ConfigPrms.getClientRegionConfig(), fn);
        ClientCacheHelper.createCacheFromXml(fn);
    }

    public static void createRegionTask() {
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
    }

    public static void createClientRegionTask() {
        ClientRegionHelper.createRegion(ConfigPrms.getClientRegionConfig());
    }

    public static void reportRegionTask() {
        String regionConfig = ConfigPrms.getRegionConfig();
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        Region r = RegionHelper.getRegion(rd.getRegionName());
        RegionAttributes ra = r.getAttributes();
        Log.getLogWriter().info("Region " + rd.getName() + "\n" + RegionHelper.regionAttributesToString(ra));
    }

    public static void reportClientRegionTask() {
        String regionConfig = ConfigPrms.getClientRegionConfig();
        ClientRegionDescription crd = ClientRegionHelper.getClientRegionDescription(regionConfig);
        Region r = ClientRegionHelper.getRegion(crd.getRegionName());
        RegionAttributes ra = r.getAttributes();
        Log.getLogWriter().info("Client region " + crd.getName() + "\n" + ClientRegionHelper.regionAttributesToString(ra));
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }

    public static void closeClientCacheTask() {
        ClientCacheHelper.closeCache();
    }
}

