/*
 * Decompiled with CFR 0.152.
 */
package hyperictest;

import hydra.HostHelper;
import hydra.HypericServerInstallDescription;
import hydra.HypericServerInstallHelper;
import hydra.Log;
import hydra.ProcessMgr;
import java.io.File;

public class HypericInstall {
    private static String sep = File.separator;
    private static String result;
    private static String antCmd;
    private static String antHome;
    private static String buildXmlFile;
    private static String buildVersion;
    private static String releaseNum;
    private static String installDir;
    private static String hostOS;
    private static String buildCopyDir;
    private static String hqServerDb;
    private static String cmdProperty;
    private static String oracleDbUser;
    private static String oracleDbPwd;
    private static String oracleDbUrl;
    private static String oracleSID;
    private static String oracleAdminUser;
    private static String oracleAdminPwd;
    private static String mysqlDbUser;
    private static String mysqlDbPwd;
    private static String mysqlDbUrl;
    private static String mysqlPort;
    private static String mysqlAdminUser;
    private static String mysqlAdminPwd;
    private static String agentHost;
    private static String agentServerHost;
    private static String agentPort;

    private static String getCmdPropertyString() {
        String agentHostName = HostHelper.getLocalHost();
        HypericServerInstallDescription hqd = HypericServerInstallHelper.getHypericServerInstallDescription(agentHostName);
        antHome = hqd.hostDescription.getAntHome();
        buildXmlFile = hqd.buildXmlFile;
        buildVersion = hqd.buildVersion;
        releaseNum = hqd.releaseNum;
        installDir = hqd.installDir;
        hostOS = hqd.hostOS;
        buildCopyDir = hqd.buildCopyDir;
        hqServerDb = hqd.hqServerDb;
        agentHost = hqd.agentHost;
        agentServerHost = hqd.agentServerHost;
        agentPort = hqd.agentPort;
        antCmd = hostOS.equals("win32") ? antHome + sep + "bin" + sep + "ant.bat" + " " : antHome + sep + "bin" + sep + "ant --noconfig" + " ";
        cmdProperty = antCmd + "-Drelease.num=" + releaseNum + " ";
        cmdProperty = cmdProperty + "-Dagent.host.ip=" + agentHost + " ";
        cmdProperty = cmdProperty + "-Dagent.cam.ip=" + agentServerHost + " ";
        cmdProperty = cmdProperty + "-Dagent.port=" + agentPort + " ";
        cmdProperty = cmdProperty + "-Dserver.host=" + agentServerHost + " ";
        if (hqServerDb != null && hqServerDb.equalsIgnoreCase("mysql")) {
            mysqlDbUser = hqd.mysqlDbUser;
            mysqlDbPwd = hqd.mysqlDbPwd;
            mysqlAdminUser = hqd.mysqlAdminUser;
            mysqlAdminPwd = hqd.mysqlAdminPwd;
            mysqlDbUrl = hqd.mysqlDbUrl;
            mysqlPort = hqd.mysqlPort;
            cmdProperty = cmdProperty + "-Dmysql.db.user=" + mysqlDbUser + " ";
            cmdProperty = cmdProperty + "-Dmysql.db.password=" + mysqlDbPwd + " ";
            cmdProperty = cmdProperty + "-Dmysql.db.url=" + mysqlDbUrl + " ";
            cmdProperty = cmdProperty + "-Dmysql.db.admin.user=" + mysqlAdminUser + " ";
            cmdProperty = cmdProperty + "-Dmysql.db.admin.password=" + mysqlAdminPwd + " ";
            cmdProperty = cmdProperty + "-Dmysql.db.port=" + mysqlPort + " ";
        } else if (hqServerDb != null && hqServerDb.equalsIgnoreCase("oracle")) {
            oracleDbUser = hqd.oracleDbUser;
            oracleDbPwd = hqd.oracleDbPwd;
            oracleAdminUser = hqd.oracleAdminUser;
            oracleAdminPwd = hqd.oracleAdminPwd;
            oracleDbUrl = hqd.oracleDbUrl;
            oracleSID = hqd.oracleSID;
            cmdProperty = cmdProperty + "-Doracle.db.user=" + oracleDbUser + " ";
            cmdProperty = cmdProperty + "-Doracle.db.password=" + oracleDbPwd + " ";
            cmdProperty = cmdProperty + "-Doracle.db.url=" + oracleDbUrl + " ";
            cmdProperty = cmdProperty + "-Doracle.db.admin.user=" + oracleAdminUser + " ";
            cmdProperty = cmdProperty + "-Doracle.db.admin.password=" + oracleAdminPwd + " ";
            cmdProperty = cmdProperty + "-Doracle.db.sid=" + oracleSID + " ";
        }
        cmdProperty = cmdProperty + "-Dbuild.version=" + buildVersion + " ";
        cmdProperty = cmdProperty + "-Dinstall.dir=" + installDir + " ";
        cmdProperty = cmdProperty + "-Dbuild.os=" + hostOS + " ";
        cmdProperty = cmdProperty + "-Dbuild.copy.dir=" + buildCopyDir + " ";
        cmdProperty = cmdProperty + "-Dhq.server.db=" + hqServerDb + " ";
        return cmdProperty;
    }

    public static void recreateHQServerDBSchema() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " recreateHQServerDBSchema " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void downloadHQAgentBuild() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " copyAndExtractHQAgentBuild " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void setupHQAgent() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " setupHQAgent " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void downloadHQServerBuild() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " copyAndExtractHQServerBuild " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void configureHQServer() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " configureHQServerBuild " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void setupHQServer() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " setupHQServer " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void startHQServer() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " startHQServer " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }

    public static void stopHQServer() {
        String cmdProperty = HypericInstall.getCmdPropertyString();
        String cmd = cmdProperty + "-f " + buildXmlFile + " stopHQServer " + " ";
        result = ProcessMgr.fgexec(cmd, 1800);
        Log.getLogWriter().info(result);
    }
}

