/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import jline.UnixTerminal;
import management.util.HydraUtil;

public class VirtualUnixTerminal
extends UnixTerminal {
    public void initializeTerminal() throws IOException, InterruptedException {
        HydraUtil.logInfo("Using virtual UnixTerminal");
    }

    public void restoreTerminal() throws Exception {
        VirtualUnixTerminal.resetTerminal();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (c == 27 && in.available() > 0) {
            while (c == 27) {
                c = this.readCharacter(in);
            }
            if (c == 91 || c == 79) {
                c = this.readCharacter(in);
                if (c == 65) {
                    return 16;
                }
                if (c == 66) {
                    return 14;
                }
                if (c == 68) {
                    return 2;
                }
                if (c == 67) {
                    return 6;
                }
                if (c == 72) {
                    return 1;
                }
                if (c == 70) {
                    return 5;
                }
                if (c == 51) {
                    c = this.readCharacter(in);
                    return 127;
                }
            }
        }
        if (c > 128) {
            this.replayStream.setInput(c, in);
            c = this.replayReader.read();
        }
        return c;
    }

    public boolean isANSISupported() {
        return !Boolean.getBoolean("gfsh.disable.color");
    }
}

