/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.internal.datasource.DataSourceFactory;
import com.gemstone.gemfire.internal.jta.GlobalTransaction;
import dunit.DistributedTestCase;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DerbyServerHelper;
import hydra.Log;
import hydra.PoolHelper;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import jta.DBLoader;
import jta.DBUtil;
import jta.JtaBB;
import jta.JtaPrms;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class JtaCacheCallbackHydraTest {
    static final String TABLENAME = "CacheTest";
    static boolean isSerialExecution;

    public static void createDatabase() {
        try {
            if (JtaPrms.useDerbyNetworkServer()) {
                GlobalTransaction.DISABLE_TRANSACTION_TIMEOUT_SETTING = true;
                DataSourceFactory.setTestConnectionUrl((String)JtaCacheCallbackHydraTest.getDerbyURL());
                DataSourceFactory.setTestConnectionHost((String)DerbyServerHelper.getEndpoint().getHost());
                DataSourceFactory.setTestConnectionPort((String)String.valueOf(DerbyServerHelper.getEndpoint().getPort()));
            }
            Cache cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            Log.getLogWriter().info("Creating database ...");
            DBUtil.createTable(TABLENAME);
            Log.getLogWriter().info("Created database.");
            CacheHelper.closeCache();
        }
        catch (Exception e) {
            throw new TestException("Error in createDatabase()" + TestHelper.getStackTrace(e));
        }
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (CacheHelper.getCache() == null) {
            TransactionWriter txWriter;
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            TransactionListener txListener = JtaPrms.getTxListener();
            if (txListener != null) {
                c.getCacheTransactionManager().setListener(txListener);
                Log.getLogWriter().info("Installed TransactionListener " + txListener);
            }
            if ((txWriter = JtaPrms.getTxWriter()) != null) {
                c.getCacheTransactionManager().setWriter(txWriter);
                Log.getLogWriter().info("Installed TransactionWriter " + txWriter);
            }
            try {
                Region root = RegionHelper.createRegion("root", ConfigPrms.getRegionConfig());
                RegionAttributes ratts = RegionHelper.getRegionAttributes("bridgeSubregion");
                Log.getLogWriter().info("Creating employee subregion ...");
                Region employee = root.createSubregion("employee", ratts);
                Log.getLogWriter().info("Created employee subregion.");
            }
            catch (Exception e) {
                throw new TestException("Error in initTask() " + TestHelper.getStackTrace(e));
            }
        }
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    public static void dumpDatabase() {
        try {
            if (JtaPrms.useDerbyNetworkServer()) {
                GlobalTransaction.DISABLE_TRANSACTION_TIMEOUT_SETTING = true;
                DataSourceFactory.setTestConnectionUrl((String)JtaCacheCallbackHydraTest.getDerbyURL());
                DataSourceFactory.setTestConnectionHost((String)DerbyServerHelper.getEndpoint().getHost());
                DataSourceFactory.setTestConnectionPort((String)String.valueOf(DerbyServerHelper.getEndpoint().getPort()));
            }
            Cache cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            DBUtil.displayData(TABLENAME);
            CacheHelper.closeCache();
        }
        catch (Exception e) {
            throw new TestException("Error in dumpDatabase()" + TestHelper.getStackTrace(e));
        }
    }

    public static synchronized void loadCache() {
        Cache cache = CacheHelper.getCache();
        Region employee = RegionHelper.getRegion("/root/employee");
        if (employee.isEmpty()) {
            Log.getLogWriter().info("Loading database entries into cache ....");
            for (int i = 1; i <= 4; ++i) {
                String key = "key" + i;
                employee.get((Object)key);
            }
        }
        Log.getLogWriter().info("Loaded database entries into cache.");
    }

    public static synchronized void initTask() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            try {
                TransactionWriter txWriter;
                System.setProperty("derby.locks.waitTimeout", "180");
                if (JtaPrms.useDerbyNetworkServer()) {
                    GlobalTransaction.DISABLE_TRANSACTION_TIMEOUT_SETTING = true;
                    DataSourceFactory.setTestConnectionUrl((String)JtaCacheCallbackHydraTest.getDerbyURL());
                    DataSourceFactory.setTestConnectionHost((String)DerbyServerHelper.getEndpoint().getHost());
                    DataSourceFactory.setTestConnectionPort((String)String.valueOf(DerbyServerHelper.getEndpoint().getPort()));
                }
                cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
                TransactionListener txListener = JtaPrms.getTxListener();
                if (txListener != null) {
                    cache.getCacheTransactionManager().setListener(txListener);
                    Log.getLogWriter().info("Installed TransactionListener " + txListener);
                }
                if ((txWriter = JtaPrms.getTxWriter()) != null) {
                    cache.getCacheTransactionManager().setWriter(txWriter);
                    Log.getLogWriter().info("Installed TransactionWriter " + txWriter);
                }
                Region root = cache.getRegion("root");
                RegionAttributes ratts = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
                String poolConfig = ratts.getPoolName();
                if (poolConfig != null) {
                    PoolHelper.createPool(poolConfig);
                }
                Log.getLogWriter().info("Creating employee subregion ...");
                Region employee = root.createSubregion("employee", ratts);
                if (employee.getAttributes().getPoolName() != null) {
                    employee.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                    Log.getLogWriter().info("registered interest in ALL_KEYS for " + employee.getFullPath());
                }
                Log.getLogWriter().info("Created employee subregion.");
            }
            catch (Exception e) {
                throw new TestException("Error in initTask() " + TestHelper.getStackTrace(e));
            }
            isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testTask() {
        block21: {
            long localCounter = 0L;
            String key = null;
            String dbValue = null;
            String newValue = null;
            String regionVal = null;
            boolean isRollBack = false;
            TestHelper.checkForEventError(JtaBB.getBB());
            Cache cache = CacheHelper.getCache();
            Region employee = cache.getRegion("root/employee");
            ((DBLoader)employee.getAttributes().getCacheLoader()).setTxLoad(true);
            try {
                Context ctx = null;
                UserTransaction utx = null;
                ctx = cache.getJNDIContext();
                utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
                boolean rolledback = false;
                utx.begin();
                localCounter = JtaBB.getBB().getSharedCounters().incrementAndRead(JtaBB.COUNTER);
                key = "key" + (localCounter % 4L + 1L);
                newValue = "value" + localCounter;
                dbValue = DBUtil.getDBValue(TABLENAME, key);
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    regionVal = (String)employee.get((Object)key);
                    Log.getLogWriter().info("region value for key (" + key + ") = " + regionVal);
                }
                Log.getLogWriter().info("Selected " + key + " for update, original dbValue is " + dbValue + " new value will be " + newValue);
                employee.put((Object)key, (Object)newValue);
                if (JtaPrms.executeDBOpsInline()) {
                    try {
                        Connection conn = DBUtil.getXADSConnection();
                        String sql = "UPDATE CacheTest SET name = '" + newValue + "' WHERE id = ('" + key + "')";
                        int i = DBUtil.executeUpdate(sql, conn);
                        Log.getLogWriter().info("rows updated = " + i);
                        conn.close();
                    }
                    catch (Exception e) {
                        Class<JtaCacheCallbackHydraTest> sql = JtaCacheCallbackHydraTest.class;
                        synchronized (JtaCacheCallbackHydraTest.class) {
                            Log.getLogWriter().info("testTask caught " + e, (Throwable)e);
                            if (e.getMessage().indexOf("A lock could not be obtained") >= 0) {
                                DistributedTestCase.dumpMyThreads(Log.getLogWriter());
                            }
                            // ** MonitorExit[sql] (shouldn't be in output)
                            throw new TestException("testTask caught " + e);
                        }
                    }
                }
                try {
                    if (TestConfig.tab().getRandGen().nextInt(1, 100) < 25) {
                        Log.getLogWriter().info("ROLLING BACK transaction with " + key + "(" + newValue + ")");
                        utx.rollback();
                        Log.getLogWriter().info("ROLLED BACK.");
                        isRollBack = true;
                    } else {
                        Log.getLogWriter().info("COMMITTING transaction with " + key + "(" + newValue + ")");
                        utx.commit();
                        Log.getLogWriter().info("COMMITTED.");
                    }
                }
                catch (RollbackException r) {
                    boolean isCausedByTransactionWriterException;
                    Throwable causedBy = r.getCause();
                    String errStr = causedBy.toString();
                    boolean bl = isCausedByTransactionWriterException = errStr.indexOf("intentionally throw") >= 0;
                    if (isSerialExecution && !isCausedByTransactionWriterException) {
                        throw new TestException("Unexpected exception " + (Object)((Object)r) + " caught in serialExecution test");
                    }
                    Log.getLogWriter().info("Caught RolledbackException " + (Object)((Object)r) + " for " + key + "(" + newValue + "): expected with concurrent operations, continuing test");
                    isRollBack = true;
                }
                catch (Exception e) {
                    Log.getLogWriter().error("testTask caught exception during commit/rollback ", (Throwable)e);
                    throw new TestException("Error in testTask during commit/rollback " + TestHelper.getStackTrace(e));
                }
                if (!isSerialExecution) break block21;
                try {
                    Log.getLogWriter().info("Validating data consistency for " + (isRollBack ? "Rollback" : "Commit") + " with " + key + "(" + newValue + ")");
                    if (!JtaCacheCallbackHydraTest.checkData(employee, key, newValue, !isRollBack)) {
                        String s = "Region/DataBase inconsistent for " + (isRollBack ? "Rollback" : "Commit") + " with " + key + "(" + newValue + ")";
                        Log.getLogWriter().info(s);
                        throw new TestException(s + " " + TestHelper.getStackTrace());
                    }
                    Log.getLogWriter().info("data consistency verified after " + (isRollBack ? "Rollback" : "Commit") + " for " + key + "(" + newValue + ")");
                }
                catch (Exception e) {
                    String s = "Exception while retrieving the Data for validation of commit for " + key + "(" + newValue + ")";
                    Log.getLogWriter().info(s, (Throwable)e);
                    throw new TestException(s + " " + TestHelper.getStackTrace(e));
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
            }
            catch (TransactionDataRebalancedException e) {
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
            }
            catch (Exception e) {
                Log.getLogWriter().error("Exception caught in testTask() for " + key + "(" + newValue + ")", (Throwable)e);
                throw new TestException("Error in testTask() " + TestHelper.getStackTrace(e));
            }
        }
    }

    public static boolean checkData(Region region, String key, String value, boolean isCommit) throws Exception {
        String regionVal = (String)region.get((Object)key);
        Log.getLogWriter().info("checkData (" + (isCommit ? "commit" : "rollback") + ") for " + key + " and newValue " + value + " found region value " + regionVal);
        if (isCommit) {
            if (!regionVal.equals(value)) {
                Log.getLogWriter().info("checkData (on commit): region value for " + key + " is " + regionVal + ", expected newValue " + value);
                return false;
            }
        } else if (regionVal.equals(value)) {
            Log.getLogWriter().info("checkData (on rollback): region value for " + key + " is " + regionVal + ", did not expect it to be updated to newValue " + value + " after rollback");
            return false;
        }
        return true;
    }

    public static void closeTask() {
        JtaCacheCallbackHydraTest.validateFinally();
    }

    public static void validateFinally() {
        Cache cache = CacheHelper.getCache();
        Region employee = cache.getRegion("root/employee");
        Set keySet = employee.keySet();
        StringBuffer aStr = new StringBuffer();
        Map map = null;
        try {
            map = DBUtil.getData(TABLENAME);
        }
        catch (Exception e) {
            throw new TestException("Caught unexpected Exception in validateFinally " + e);
        }
        Set dbKeys = map.keySet();
        if (dbKeys.size() != keySet.size()) {
            aStr.append("Inconsistency detected with database size = " + dbKeys.size() + " and cache size = " + keySet.size());
        }
        for (String key : keySet) {
            if (dbKeys.contains(key)) continue;
            aStr.append(key + " missing from database\n");
        }
        for (String key : dbKeys) {
            if (keySet.contains(key)) continue;
            aStr.append(key + " missing from GemFire cache\n");
        }
        StringBuffer displayStr = new StringBuffer();
        try {
            Log.getLogWriter().info("In validateFinally(), verifying " + map.size() + " entries");
            for (String key : keySet) {
                String regionValue = (String)employee.get((Object)key);
                String dbValue = DBUtil.getDBValue(TABLENAME, key);
                displayStr.append("  " + key + " dbValue = " + dbValue + " regionValue = " + regionValue + "\n");
                if (dbValue.equals(regionValue)) continue;
                aStr.append("Data inconsistency detected for " + key + " dbValue = " + dbValue + " and regionValue " + regionValue);
            }
        }
        catch (Exception e) {
            throw new TestException("Caught unexpected Exception in validateFinally " + e);
        }
        if (aStr.length() > 0) {
            Log.getLogWriter().info("Validation FAILED\n" + displayStr.toString());
            throw new TestException(aStr.toString() + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("Validation SUCCESSFUL\n" + displayStr.toString());
    }

    private static String getDerbyURL() {
        String protocol = "jdbc:derby:";
        String dbName = "newDB";
        String host = DerbyServerHelper.getEndpoint().getHost();
        int port = DerbyServerHelper.getEndpoint().getPort();
        StringBuffer url = new StringBuffer();
        url.append(protocol);
        url.append("//" + host + ":" + port + "/");
        url.append(dbName);
        url.append(";create=true");
        Log.getLogWriter().info("Derby URL = " + url.toString());
        return url.toString();
    }

    public static void HydraTask_stopStartServerVM() {
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        int randInt = TestConfig.tab().getRandGen().nextInt(1, numVMsToStop);
        Object[] objArr = StopStartVMs.getOtherVMsWithExclude(randInt, "edge");
        List clientVmInfoList = (List)objArr[0];
        List stopModeList = (List)objArr[1];
        StopStartVMs.stopStartVMs(clientVmInfoList, stopModeList);
    }
}

