/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import java.sql.Connection;
import jta.DBUtil;
import util.AbstractWriter;
import util.TestHelper;

public class JtaDBWriter
extends AbstractWriter
implements CacheWriter {
    String tableName = "CacheTest";

    public void beforeUpdate(EntryEvent event) throws CacheWriterException {
        this.logCall("beforeUpdate", (CacheEvent)event);
        String key = (String)event.getKey();
        String newValue = (String)event.getNewValue();
        String oldValue = (String)event.getOldValue();
        try {
            Connection conn = DBUtil.getXADSConnection();
            String sql = "UPDATE " + this.tableName + " SET name = '" + newValue + "' WHERE id = ('" + key + "')";
            int i = DBUtil.executeUpdate(sql, conn);
            Log.getLogWriter().info("rows updated = " + i);
            conn.close();
        }
        catch (Exception e) {
            Log.getLogWriter().info("JtaDBWriter.beforeUpdate() caught " + e);
            throw new CacheWriterException("JtaDBWriter.beforeUpdate() caught " + e);
        }
    }

    public void beforeCreate(EntryEvent event) throws CacheWriterException {
        this.logCall("beforeCreate", (CacheEvent)event);
        Operation op = event.getOperation();
        if (op.equals(Operation.LOCAL_LOAD_CREATE)) {
            return;
        }
        String key = (String)event.getKey();
        String newValue = (String)event.getNewValue();
        String oldValue = (String)event.getOldValue();
        try {
            Connection conn = DBUtil.getXADSConnection();
            String sql = "UPDATE " + this.tableName + " SET name = '" + newValue + "' WHERE id = ('" + key + "')";
            int i = DBUtil.executeUpdate(sql, conn);
            Log.getLogWriter().info("rows updated for create = " + i);
            conn.close();
        }
        catch (Exception e) {
            Log.getLogWriter().info("JtaDBWriter.beforeCreate() caught " + TestHelper.getStackTrace(e));
            throw new CacheWriterException("JtaDBWriter.beforeCreate() caught " + TestHelper.getStackTrace(e));
        }
    }

    public void beforeDestroy(EntryEvent event) throws CacheWriterException {
        this.logCall("beforeDestroy", (CacheEvent)event);
        String key = (String)event.getKey();
        String newValue = (String)event.getNewValue();
        String oldValue = (String)event.getOldValue();
        String sql = "DELETE FROM " + this.tableName + " WHERE id = ('" + key + "')";
        try {
            Connection conn = DBUtil.getXADSConnection();
            int i = DBUtil.executeUpdate(sql, conn);
            Log.getLogWriter().info("rows destroyed = " + i);
            conn.close();
        }
        catch (Exception e) {
            Log.getLogWriter().info("JtaDBWriter.beforeDestroy() caught " + TestHelper.getStackTrace(e));
            throw new CacheWriterException("JtaDBWriter.beforeDestroy() caught " + TestHelper.getStackTrace(e));
        }
    }

    public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
    }

    public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
    }

    public void close() {
    }
}

