/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import hydra.CacheHelper;
import hydra.Log;
import java.util.Random;
import javax.naming.Context;
import javax.transaction.UserTransaction;
import jta.JtaPrms;
import util.TestException;
import util.TestHelper;

public class JtaTimeOutHydraTest {
    public static synchronized void initTask() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            try {
                cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            }
            catch (Exception e) {
                throw new TestException("Error in Cache Initialiaation in initTask " + TestHelper.getStackTrace(e));
            }
        }
    }

    public static void testTask() {
        boolean exceptionOccurred = false;
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            Log.getLogWriter().info("Starting Transaction ");
            int txnTimeOut = new Random().nextInt(10) + 1;
            int sleepTime = (new Random().nextInt(11) + 1) * 1000;
            Log.getLogWriter().info("Txn TimeOut =" + txnTimeOut + " sleepTime " + sleepTime);
            utx.begin();
            utx.setTransactionTimeout(txnTimeOut);
            Thread.sleep(sleepTime);
            try {
                utx.commit();
            }
            catch (Exception e) {
                if (txnTimeOut > sleepTime / 1000) {
                    Log.getLogWriter().info("Commit threw", (Throwable)e);
                    throw new Exception("Commit threw " + e);
                }
                exceptionOccurred = true;
            }
            if (txnTimeOut < sleepTime / 1000 && !exceptionOccurred) {
                throw new Exception("Expected (transaction timeout) Exception did not occur");
            }
            Log.getLogWriter().info("Successfully Committed Transaction ");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Unexpected Exception in testTask", (Throwable)e);
            throw new TestException("Unexpected Exception in testTask " + TestHelper.getStackTrace(e));
        }
    }
}

