/*
 * Decompiled with CFR 0.152.
 */
package koch;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedConnectionMgr;
import hydra.HydraRuntimeException;
import hydra.Log;
import koch.KochPrms;

public class MCache {
    private Cache myCache;
    private Region myRegion;

    public MCache() {
        this.setUpRegion();
    }

    public Object getItem(String id) {
        Object theObj = null;
        try {
            theObj = this.myRegion.get((Object)id);
            if (theObj == null) {
                Log.getLogWriter().info("Obj with key: " + id + " was null");
            }
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Problem getting object", e);
        }
        try {
            if (KochPrms.unloadAfterOperation()) {
                this.myRegion.invalidate((Object)id);
            }
        }
        catch (CacheException e) {
            throw new HydraRuntimeException("Problem unloading object", (Exception)((Object)e));
        }
        return theObj;
    }

    public void putItem(String id, Object obj) {
        try {
            this.myRegion.put((Object)id, obj);
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Problem replacing object", e);
        }
        try {
            if (KochPrms.unloadAfterOperation()) {
                this.myRegion.invalidate((Object)id);
            }
        }
        catch (CacheException e) {
            throw new HydraRuntimeException("Problem unloading object", (Exception)((Object)e));
        }
    }

    public void setUpRegion() {
        try {
            DistributedSystem ds = DistributedConnectionMgr.connect();
            this.myCache = CacheFactory.create((DistributedSystem)ds);
        }
        catch (CacheException e) {
            throw new HydraRuntimeException("Problem creating cache", (Exception)((Object)e));
        }
        try {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes myAttributes = factory.createRegionAttributes();
            Region rootRegion = this.myCache.createVMRegion("Root", myAttributes);
            this.myRegion = rootRegion.createSubregion("MyObjects", myAttributes);
        }
        catch (CacheException e) {
            throw new HydraRuntimeException("Problem setting up regions", (Exception)((Object)e));
        }
    }

    public void closeCache() {
        this.myCache.close();
        this.myCache = null;
        DistributedConnectionMgr.disconnect();
    }

    public static void cycleTask() {
        MCache test = new MCache();
        test.putItem("stuff", "A bunch of crud");
        Object result = test.getItem("stuff");
        test.closeCache();
        try {
            ClientVmMgr.stopAsync("bouncing", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            throw new HydraRuntimeException("Unable to bounce this VM", e);
        }
    }
}

