/*
 * Decompiled with CFR 0.152.
 */
package management.cli;

import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;

public class CLIBlackboard
extends Blackboard {
    static String BB_NAME = "CLI_Blackboard";
    static String BB_TYPE = "RMI";
    private static CLIBlackboard bbInstance = null;
    public static int VM_TASKS_COMPLETE_COUNT;
    public static int gfshExecutionNumber;
    public static int gfshExecutionNumberCompleted;
    public static int gemfireExecutionNumber;
    public static int gemfireExecutionNumberCompleted;
    public static int functionExecutionNumber;
    public static int functionDeletionNumber;
    public static int FILE_COUNTER;
    public static int DIRECTORY_COUNTER;
    public static int REGION_COUNTER;
    public static final String COMMAND_MAP = "commandMap";
    public static final String COMMAND_EXECUTOR_MAP = "commandExecutorsMap";
    public static final String COMMAND_TASK_MAP = "commandTaskMap";
    public static final String FUNCTION_EXEC_LIST = "FUNCTION_EXEC_LIST";
    public static final String FUNCTION_EXEC_RESULTCOLLECTOR = "FUNCTION_EXEC_RESULTCOLLECTOR";
    public static final String FUNCTION_DELETE_LIST = "FUNCTION_DELETE_LIST";
    public static final String GW_SENDER_ID_LIST = "GW_SENDER_ID_LIST";
    public static final String GW_SENDER_RUNNING_LIST = "GW_SENDER_RUNNING";
    public static final String GW_SENDER_PAUSED_LIST = "GW_SENDER_PAUSED";
    public static final String GW_SENDER_STOPPED_LIST = "GW_SENDER_STOPPED";
    public static final String GW_RECEIVER_STOPPED_LIST = "GW_RECEIVER_STOPPED";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CLIBlackboard getBB() {
        if (bbInstance != null) return bbInstance;
        Class<CLIBlackboard> clazz = CLIBlackboard.class;
        synchronized (CLIBlackboard.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new CLIBlackboard(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public CLIBlackboard() {
    }

    public CLIBlackboard(String name, String type) {
        super(name, type, CLIBlackboard.class);
    }

    public void saveMap(String key, Map map) {
        this.getSharedMap().put(key, map);
    }

    public Map getMap(String key) {
        return (Map)this.getSharedMap().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandsForNextExecution(TestCommand command, TestCommandInstance instance) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            Map map = CLIBlackboard.getBB().getMap(COMMAND_TASK_MAP);
            map.put("command", command);
            map.put("instance", instance);
            CLIBlackboard.getBB().saveMap(COMMAND_TASK_MAP, map);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCommandsForNextExecution() {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            Map map = CLIBlackboard.getBB().getMap(COMMAND_TASK_MAP);
            TestCommand command = (TestCommand)map.get("command");
            TestCommandInstance instance = (TestCommandInstance)map.get("instance");
            Object[] objectArray = new Object[]{command, instance};
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToList(String list, Object object) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            List bbList = (List)CLIBlackboard.getBB().getSharedMap().get(list);
            bbList.add(object);
            CLIBlackboard.getBB().getSharedMap().put(list, bbList);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearList(String list) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            List bbList = (List)CLIBlackboard.getBB().getSharedMap().get(list);
            bbList.clear();
            CLIBlackboard.getBB().getSharedMap().put(list, bbList);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveList(String list, List bbList) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            CLIBlackboard.getBB().getSharedMap().put(list, bbList);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromList(String list, Object object) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            List bbList = (List)CLIBlackboard.getBB().getSharedMap().get(list);
            bbList.remove(object);
            CLIBlackboard.getBB().getSharedMap().put(list, bbList);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getList(String list) {
        SharedLock lock = this.getSharedLock();
        try {
            List bbList;
            lock.lock();
            List list2 = bbList = (List)CLIBlackboard.getBB().getSharedMap().get(list);
            return list2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initBlackBoard() {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            if (!CLIBlackboard.getBB().getSharedMap().containsKey(COMMAND_TASK_MAP)) {
                CLIBlackboard.getBB().getSharedMap().put(COMMAND_TASK_MAP, new HashMap());
            }
            if (!CLIBlackboard.getBB().getSharedMap().containsKey(FUNCTION_EXEC_LIST)) {
                CLIBlackboard.getBB().getSharedMap().put(FUNCTION_EXEC_LIST, new ArrayList());
            }
            if (!CLIBlackboard.getBB().getSharedMap().containsKey(FUNCTION_EXEC_RESULTCOLLECTOR)) {
                CLIBlackboard.getBB().getSharedMap().put(FUNCTION_EXEC_RESULTCOLLECTOR, new ArrayList());
            }
            if (!CLIBlackboard.getBB().getSharedMap().containsKey(FUNCTION_DELETE_LIST)) {
                CLIBlackboard.getBB().getSharedMap().put(FUNCTION_DELETE_LIST, new ArrayList());
            }
            if (!CLIBlackboard.getBB().getSharedMap().containsKey(GW_SENDER_ID_LIST)) {
                CLIBlackboard.getBB().getSharedMap().put(GW_SENDER_ID_LIST, new ArrayList());
            }
        }
        finally {
            lock.unlock();
        }
    }
}

