/*
 * Decompiled with CFR 0.152.
 */
package management.cli;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import management.cli.ShellEvent;
import management.cli.Util;

public class EventedInputStream
extends InputStream
implements ShellEvent {
    public static final int DEFAULT_SIZE = 1024;
    private ByteArrayInputStream bis = null;
    private int size = 1024;
    private StringBuilder buffer = new StringBuilder();
    private AtomicBoolean streamClosed = new AtomicBoolean(false);
    private AtomicInteger events = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    private final Condition eventsCompleted = this.lock.newCondition();
    private final Condition eventsArrived = this.lock.newCondition();
    private StringBuilder bufferFormdAfterReading = new StringBuilder();

    public EventedInputStream(int size) {
        this.size = size;
    }

    public EventedInputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        this.lock.lock();
        try {
            Util.debug("Waiting for new events to arrive and complete events " + this.events.get());
            while (this.events.get() == 0) {
                try {
                    this.eventsCompleted.await();
                }
                catch (InterruptedException e1) {
                    Util.error(e1);
                    e1.printStackTrace();
                }
            }
            while (this.bis == null) {
                try {
                    this.eventsCompleted.await();
                }
                catch (InterruptedException e1) {
                    Util.error(e1);
                    e1.printStackTrace();
                }
            }
            Util.debug("All events have been arrived =" + this.events.get());
            int charRead = this.bis.read();
            if (charRead == -1) {
                if (!this.streamClosed.get()) {
                    Util.debug("All input characters have been consumed so wait again events = " + this.events.get());
                    try {
                        this.eventsCompleted.await();
                    }
                    catch (InterruptedException e1) {
                        Util.error(e1);
                        e1.printStackTrace();
                    }
                    Util.debug("Wait complete with new events = " + this.events.get());
                    if (this.events.get() > 0) {
                        charRead = this.bis.read();
                        Util.debug("Returning char " + charRead);
                        this.bufferFormdAfterReading.append((char)charRead);
                        int e1 = charRead;
                        return e1;
                    }
                    if (this.events.get() == -1) {
                        int e1 = -1;
                        return e1;
                    }
                    RuntimeException e = new RuntimeException("you should not reach here without any events !!!! Events " + this.events.get() + " streamClsoed " + this.streamClosed.get());
                    Util.error(e);
                    throw e;
                }
                int n = -1;
                return n;
            }
            this.bufferFormdAfterReading.append((char)charRead);
            int n = charRead;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) {
        this.lock.lock();
        try {
            this.check();
            int n = this.bis.read(b, off, len);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) {
        this.lock.lock();
        try {
            this.check();
            long l = this.bis.skip(n);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        this.lock.lock();
        try {
            this.check();
            int n = this.bis.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        this.lock.lock();
        try {
            this.check();
            boolean bl = this.bis.markSupported();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) {
        this.lock.lock();
        try {
            this.check();
            this.bis.mark(readAheadLimit);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.check();
            this.bis.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void check() {
        if (this.bis == null) {
            if (this.streamClosed.get()) {
                return;
            }
            try {
                throw new RuntimeException();
            }
            catch (Exception e) {
                Util.debug("End not called ");
                e.printStackTrace();
                throw new RuntimeException("Event End not marked use end() method to end events before calling InputStream methods.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.bis != null) {
                this.bis.close();
            }
            this.streamClosed.set(false);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellEvent tab() throws IOException {
        this.lock.lock();
        try {
            this.buffer.append('\t');
            this.events.incrementAndGet();
            this.eventsArrived.signalAll();
            EventedInputStream eventedInputStream = this;
            return eventedInputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellEvent addChars(String seq) throws IOException {
        this.lock.lock();
        try {
            this.buffer.append(seq);
            this.events.incrementAndGet();
            this.eventsArrived.signalAll();
            EventedInputStream eventedInputStream = this;
            return eventedInputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellEvent addCtrlZ() throws IOException {
        this.events.incrementAndGet();
        EventedInputStream eventedInputStream = this;
        return eventedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellEvent addCtrlD() throws IOException {
        this.events.incrementAndGet();
        EventedInputStream eventedInputStream = this;
        return eventedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellEvent newline() throws IOException {
        this.lock.lock();
        try {
            this.buffer.append(NEW_LINE);
            byte[] array = this.buffer.toString().getBytes();
            this.bis = new ByteArrayInputStream(array);
            Util.debug("End of Events due to ENTER ... with buffer " + this.buffer);
            this.eventsCompleted.signalAll();
            Util.debug("Signalled Gfsh to read next character");
            EventedInputStream eventedInputStream = this;
            return eventedInputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellEvent end() {
        this.lock.lock();
        try {
            byte[] array = this.buffer.toString().getBytes();
            this.bis = new ByteArrayInputStream(array);
            Util.debug("End of Events due to ENTER ... with buffer " + this.buffer);
            this.eventsCompleted.signalAll();
            Util.debug("Signalled Gfsh to read next character");
            EventedInputStream eventedInputStream = this;
            return eventedInputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEvents() {
        this.lock.lock();
        try {
            this.buffer = null;
            this.buffer = new StringBuilder();
            this.bis = null;
            this.bufferFormdAfterReading = new StringBuilder();
            this.events.set(0);
        }
        finally {
            this.lock.unlock();
        }
    }

    public StringBuilder getBufferFormdAfterReading() {
        return this.bufferFormdAfterReading;
    }

    @Override
    public void waitForOutput() {
    }

    @Override
    public void terminate() {
        this.events.set(0);
        this.streamClosed.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eof() {
        this.lock.lock();
        try {
            this.buffer.append(-1);
            this.events.set(-1);
            byte[] array = this.buffer.toString().getBytes();
            this.bis = new ByteArrayInputStream(array);
            this.streamClosed.set(true);
            this.eventsCompleted.signalAll();
        }
        finally {
            Util.debug("Buffer EOF notifying threads ");
            this.lock.unlock();
        }
    }
}

