/*
 * Decompiled with CFR 0.152.
 */
package management.cli;

import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.commands.ShellCommands;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.shell.GfshConfig;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import hydra.Log;
import hydra.RemoteTestModule;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Time;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.Completor;
import jline.ConsoleReader;
import jline.ConsoleReaderWrapper;
import jline.VirtualUnixTerminal;
import management.cli.EventedInputStream;
import management.cli.JLineCompletorAdapterWrapper;
import management.cli.ShellEvent;
import management.cli.Util;
import management.test.cli.CLITest;
import management.util.HydraUtil;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineCompletorAdapter;
import org.springframework.shell.core.JLineLogHandler;
import org.springframework.shell.core.Parser;
import org.springframework.shell.core.ShellPromptAccessor;
import org.springframework.shell.event.ParseResult;
import org.springframework.shell.event.ShellStatus;
import util.TestException;
import util.TestHelper;

public class TestableGfsh
extends Gfsh
implements ShellEvent {
    protected static final Object EXIT_SHELL_COMMAND = ShellCommands.class.getCanonicalName() + ".exit";
    private EventedInputStream eis = null;
    private ByteArrayOutputStream output = null;
    private JLineCompletorAdapter completorAdaptor = null;
    private Map<String, List> completorOutput = new HashMap<String, List>();
    private Map<String, Object> commandOutput = new HashMap<String, Object>();
    private ConsoleReader newConsoleReader = null;
    private String name = null;
    private String commandExecError = null;
    private CountDownLatch resultLatch = null;
    private Writer wrappedOut = null;
    private final Parser oldParser = super.getParser();
    private Parser parserHook = null;
    private long timeout = 60L;
    public static boolean useVirtualTerm = true;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static void setVirtualTerminal(boolean yes) {
        if (yes) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") == -1 && useVirtualTerm) {
                System.setProperty("jline.terminal", VirtualUnixTerminal.class.getCanonicalName());
            }
        } else {
            System.setProperty("jline.terminal", "");
        }
        if (System.getProperty("gfsh.disable.color") == null) {
            System.setProperty("gfsh.disable.color", "true");
        }
    }

    public TestableGfsh(String name, boolean launchShell, String[] args) throws ClassNotFoundException, IOException {
        super(launchShell, args, (GfshConfig)new TestableGfshConfig(name));
        this.resultLatch = new CountDownLatch(1);
        this.parserHook = new Parser(){

            public ParseResult parse(String buffer) {
                Util.debug("In parsing hook .... with input buffer <" + buffer + ">");
                ParseResult result = null;
                try {
                    result = TestableGfsh.this.oldParser.parse(buffer);
                }
                catch (Exception e) {
                    String reason = e.getMessage() != null ? " Reason: " + e.getMessage() + " Exception: " + String.valueOf(e) : " Exception: " + String.valueOf(e);
                    TestableGfsh.this.addError("Parsing failed...." + reason + " buffer returned by EIS " + TestableGfsh.this.eis.getBufferFormdAfterReading(), e);
                    return null;
                }
                if (result == null) {
                    TestableGfsh.this.addError("Parsing failed....", null);
                } else {
                    Util.log("Parse Result is " + result);
                }
                return result;
            }

            public int completeAdvanced(String buffer, int cursor, List<Completion> candidates) {
                return TestableGfsh.this.oldParser.completeAdvanced(buffer, cursor, candidates);
            }

            public int complete(String buffer, int cursor, List<String> candidates) {
                return TestableGfsh.this.oldParser.complete(buffer, cursor, candidates);
            }
        };
        this.name = name;
        Util.debug("Using CommandManager configured with commands " + this.getCommandNames(""));
        this.eis = new EventedInputStream();
        this.output = new ByteArrayOutputStream(10240);
        PrintStream sysout = new PrintStream(this.output, true);
        TestableGfsh.setGfshOutErr(sysout);
        this.wrappedOut = new BufferedWriter(new OutputStreamWriter(sysout));
        try {
            ConsoleReaderWrapper wrapper = new ConsoleReaderWrapper(this.eis, this.wrappedOut);
            Util.debug("Reader created is " + (Object)((Object)wrapper));
            this.reader = this.newConsoleReader = wrapper;
            this.completorAdaptor = new JLineCompletorAdapterWrapper(this.getParser(), this);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void setGfshOutErr(PrintStream outToUse) {
        Gfsh.gfshout = outToUse;
        Gfsh.gfsherr = outToUse;
    }

    private static void restoreGfshOutErr() {
        Gfsh.gfshout = System.out;
        Gfsh.gfsherr = System.err;
    }

    protected void addError(String string, Exception e) {
        if (e != null) {
            Util.error(string, e);
        } else {
            Util.error(string);
        }
        this.commandExecError = string;
        this.resultLatch.countDown();
    }

    public void addCompletorOutput(String buffer, List candidates) {
        this.completorOutput.put(buffer, candidates);
        this.resultLatch.countDown();
    }

    protected ExecutionStrategy getExecutionStrategy() {
        final ExecutionStrategy oldStrategy = super.getExecutionStrategy();
        return new ExecutionStrategy(){

            public Object execute(ParseResult parseResult) throws RuntimeException {
                Object obj = null;
                String command = null;
                try {
                    String method = parseResult.getMethod().getName();
                    String className = parseResult.getInstance().getClass().getCanonicalName();
                    command = className + "." + method;
                    Util.log("Executing command " + command + " with Gfsh instance " + gfshThreadLocal.get());
                    long l1 = System.currentTimeMillis();
                    obj = oldStrategy.execute(parseResult);
                    long l2 = System.currentTimeMillis();
                    Util.log("Completed execution of command " + command + " in " + (l2 - l1) + " ms.");
                    if (obj != null) {
                        Util.log("Command output class is " + obj.getClass());
                    } else {
                        obj = "VOID";
                    }
                }
                catch (Exception e) {
                    TestableGfsh.this.addError("Error running command ", e);
                    throw new RuntimeException(e);
                }
                Util.debug("Adding outuut and notifying threads ..");
                TestableGfsh.this.addOutput(command, obj);
                if (command.equals(EXIT_SHELL_COMMAND)) {
                    TestableGfsh.this.resultLatch.countDown();
                }
                return obj;
            }

            public boolean isReadyForCommands() {
                return oldStrategy.isReadyForCommands();
            }

            public void terminate() {
                oldStrategy.terminate();
                Util.log("GFSH is exiting now, thankyou for using");
            }
        };
    }

    protected ConsoleReader createConsoleReader() {
        Util.debug("Returning wrapper reader -->" + this.newConsoleReader);
        return this.newConsoleReader;
    }

    private void myremoveHandlers(Logger l) {
        Handler[] handlers = l.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                l.removeHandler(h);
            }
        }
    }

    public void run() {
        gfshThreadLocal.set(this);
        Util.debug("Setting threadLocal " + gfshThreadLocal.get());
        this.reader = this.createConsoleReader();
        this.setPromptPath(null);
        JLineLogHandler handler = new JLineLogHandler(this.reader, (ShellPromptAccessor)this);
        JLineLogHandler.prohibitRedraw();
        Logger mainLogger = Logger.getLogger("");
        this.myremoveHandlers(mainLogger);
        mainLogger.addHandler((Handler)handler);
        this.reader.addCompletor((Completor)this.completorAdaptor);
        this.reader.setBellEnabled(true);
        if (Boolean.getBoolean("jline.nobell")) {
            this.reader.setBellEnabled(false);
        }
        this.flash(Level.FINE, this.getProductName() + " " + this.getVersion(), "WINDOW_TITLE_SLOT");
        this.printBannerAndWelcome();
        String startupNotifications = this.getStartupNotifications();
        if (StringUtils.hasText((String)startupNotifications)) {
            this.logger.info(startupNotifications);
        }
        this.setShellStatus(ShellStatus.Status.STARTED);
        String rooArgs = System.getProperty("roo.args");
        if (rooArgs != null && !"".equals(rooArgs)) {
            this.setShellStatus(ShellStatus.Status.USER_INPUT);
            boolean success = this.executeCommand(rooArgs);
            if (this.exitShellRequest == null) {
                this.executeCommand("quit");
                this.exitShellRequest = success ? ExitShellRequest.NORMAL_EXIT : ExitShellRequest.FATAL_EXIT;
            }
            this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
        } else {
            this.promptLoop();
        }
        Util.debug("Exiting the shell");
    }

    public String getShellName() {
        return "Gfsh Launcher - " + this.name;
    }

    @Override
    public ShellEvent tab() throws IOException {
        return this.eis.tab();
    }

    @Override
    public ShellEvent addChars(String seq) throws IOException {
        return this.eis.addChars(seq);
    }

    @Override
    public ShellEvent addCtrlZ() throws IOException {
        return this.eis.addCtrlZ();
    }

    @Override
    public ShellEvent addCtrlD() throws IOException {
        return this.eis.addCtrlD();
    }

    @Override
    public ShellEvent newline() throws IOException {
        this.eis.newline();
        return this.end();
    }

    @Override
    public synchronized ShellEvent end() {
        return this.eis.end();
    }

    @Override
    public void eof() {
        this.eis.eof();
    }

    @Override
    public void terminate() {
        this.closeShell();
    }

    public void stop() {
        super.stop();
        CliUtil.isGfshVM = false;
        TestableGfsh.restoreGfshOutErr();
    }

    public void notifyDisconnect(String endPoints) {
        super.notifyDisconnect(endPoints);
        this.addError(CliStrings.format((String)"No longer connected to {0}.", (Object[])new Object[]{endPoints}), null);
    }

    public String getOutputText() {
        return this.output.toString();
    }

    public String getPlainOutputText() {
        StringBuilder strBldr = new StringBuilder();
        String tmpStr = this.output.toString();
        Util.log("getOutputText shell string is:\n" + tmpStr);
        int x = 0;
        boolean havePromptOnFront = false;
        x = tmpStr.indexOf("\\\n");
        if (x != -1) {
            tmpStr = tmpStr.substring(x + 2);
        }
        if ((x = tmpStr.indexOf(";\n")) != -1) {
            tmpStr = tmpStr.substring(x + 2);
        }
        if ((x = tmpStr.indexOf("CommandResult [")) != -1 && (x = tmpStr.indexOf(10, x)) != -1) {
            tmpStr = tmpStr.substring(x + 1);
        }
        if ((x = tmpStr.lastIndexOf(">")) != -1 && x >= tmpStr.length() - 3) {
            tmpStr = tmpStr.lastIndexOf(10) != -1 ? tmpStr.substring(0, tmpStr.lastIndexOf(10)) : "";
        }
        String mask = "\\r";
        tmpStr = tmpStr.replaceAll(mask, "").trim();
        strBldr.append(tmpStr);
        tmpStr = TestableGfsh.getPresentationString(this)[0];
        x = tmpStr.indexOf("CommandResult [");
        if (x != -1) {
            char ch;
            --x;
            while (x >= 0 && Character.isWhitespace(ch = tmpStr.charAt(x))) {
                --x;
            }
            tmpStr = tmpStr.substring(0, x + 1);
        }
        tmpStr = tmpStr.trim();
        strBldr.append(tmpStr);
        Util.log("getOutputText result string is:\n" + strBldr.toString());
        if (strBldr.toString().indexOf("Cluster-1") != -1 || strBldr.toString().startsWith(">")) {
            Util.log("getOutputText missed something:\n" + TestableGfsh.toHexString(this.output.toByteArray()));
        }
        return strBldr.toString();
    }

    public static String toHexString(byte[] array) {
        char[] symbols = "0123456789ABCDEF".toCharArray();
        char[] hexValue = new char[array.length * 2];
        for (int i = 0; i < array.length; ++i) {
            int current = array[i] & 0xFF;
            hexValue[i * 2 + 1] = symbols[current & 0xF];
            hexValue[i * 2] = symbols[current >> 4];
        }
        return new String(hexValue);
    }

    @Override
    public synchronized void clearEvents() {
        this.resultLatch = new CountDownLatch(1);
        this.commandExecError = null;
        this.eis.clearEvents();
        this.completorOutput.clear();
        this.commandOutput.clear();
        Util.debug("buffer before clear <" + this.reader.getCursorBuffer().toString() + ">");
        this.reader.getCursorBuffer().clearBuffer();
        Util.debug("buffer after clear <" + this.reader.getCursorBuffer().toString() + ">");
        this.output.reset();
        try {
            this.output.flush();
        }
        catch (IOException e) {
            Util.error(e);
        }
    }

    public Map<String, Object> getCommandOutput() {
        return Collections.unmodifiableMap(this.commandOutput);
    }

    public Map<String, List> getCompletorOutput() {
        return Collections.unmodifiableMap(this.completorOutput);
    }

    public void addOutput(String command, Object object) {
        this.commandOutput.put(command, object);
    }

    @Override
    public void waitForOutput() {
        try {
            boolean completed = this.resultLatch.await(this.timeout, TimeUnit.SECONDS);
            if (!completed) {
                this.commandExecError = "Command Timeout Error ";
                HydraUtil.threadDump();
                Util.error(this.commandExecError);
            }
        }
        catch (InterruptedException e) {
            this.commandExecError = "Command InterruptedException Error ";
            Util.error(this.commandExecError);
        }
    }

    protected void handleExecutionResult(Object result) {
        super.handleExecutionResult(result);
        this.resultLatch.countDown();
    }

    protected Parser getParser() {
        return this.parserHook;
    }

    public boolean hasError() {
        return this.commandExecError != null;
    }

    public String getError() {
        return this.commandExecError;
    }

    public static List<Object> autoComplete(TestableGfsh shell, String command) {
        try {
            Log.getLogWriter().info("Executing auto-complete command " + command + " with command Mgr " + CommandManager.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        try {
            shell.addChars(command).addChars("\t").newline();
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        shell.waitForOutput();
        if (shell.hasError()) {
            throw new TestException("Command " + command + " failed with error " + shell.getError());
        }
        List completorOutput = shell.getCompletorOutput().get(command);
        String outputText = shell.getOutputText();
        Map<String, Object> commandOutput = shell.getCommandOutput();
        Log.getLogWriter().info("Command completorOutput for " + command + ": " + completorOutput);
        Log.getLogWriter().info("Command outputText for " + command + ": " + outputText);
        shell.clearEvents();
        return completorOutput;
    }

    public static Object[] execAndLogCommand(TestableGfsh shell, String command, PrintWriter commandOutputFile, boolean useFineLevelForLogging) {
        try {
            Log.getLogWriter().info("Executing command " + command + " with command Mgr " + CommandManager.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        try {
            shell.addChars(command).addChars(";").newline();
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        shell.waitForOutput();
        if (shell.hasError()) {
            throw new TestException("Command " + command + " failed with error " + shell.getError());
        }
        Map completorOutput = shell.getCompletorOutput();
        String outputText = shell.getOutputText();
        Map commandOutput = shell.getCommandOutput();
        String[] tmpArr = TestableGfsh.getPresentationString(shell);
        String presentationStr = tmpArr[0];
        String errStr = tmpArr[1];
        if (!useFineLevelForLogging) {
            Log.getLogWriter().info("Command completorOutput for " + command + ": " + completorOutput);
            Log.getLogWriter().info("Command outputText for " + command + ": " + outputText);
            Log.getLogWriter().info("Command output for " + command + ": " + commandOutput);
            Log.getLogWriter().info("Presentation string for " + command + ":\n" + presentationStr);
        } else {
            Log.getLogWriter().fine("Command completorOutput for " + command + ": " + completorOutput);
            Log.getLogWriter().fine("Command outputText for " + command + ": " + outputText);
            Log.getLogWriter().fine("Command output for " + command + ": " + commandOutput);
            Log.getLogWriter().fine("Presentation string for " + command + ":\n" + presentationStr);
        }
        TestableGfsh.logCommandOutput(shell, commandOutputFile, command, presentationStr, errStr);
        commandOutput = (Map)HydraUtil.copyMap(commandOutput);
        completorOutput = (Map)HydraUtil.copyMap(completorOutput);
        shell.clearEvents();
        return new Object[]{commandOutput, completorOutput, presentationStr, errStr};
    }

    public static Object[] execCommand(TestableGfsh shell, String command, PrintWriter commandOutputFile) {
        try {
            Log.getLogWriter().info("Executing command " + command + " with command Mgr " + CommandManager.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        try {
            shell.addChars(command).addChars(";").newline();
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        shell.waitForOutput();
        if (shell.hasError()) {
            throw new TestException("Command " + command + " failed with error " + shell.getError());
        }
        Map completorOutput = shell.getCompletorOutput();
        String outputText = shell.getOutputText();
        Map commandOutput = shell.getCommandOutput();
        String[] tmpArr = TestableGfsh.getPresentationString(shell);
        String presentationStr = tmpArr[0];
        String errStr = tmpArr[1];
        commandOutput = (Map)HydraUtil.copyMap(commandOutput);
        completorOutput = (Map)HydraUtil.copyMap(completorOutput);
        shell.clearEvents();
        return new Object[]{commandOutput, completorOutput, presentationStr, errStr};
    }

    public static String[] getCommandOutputStrings(TestableGfsh shell) {
        if (TestableGfsh.hasResultObject(shell)) {
            return TestableGfsh.getPresentationString(shell);
        }
        String[] x = new String[]{shell.getOutputText(), ""};
        return x;
    }

    private static boolean hasResultObject(TestableGfsh shell) {
        for (Object value : shell.getCommandOutput().values()) {
            if (!(value instanceof CommandResult)) continue;
            CommandResult cr = (CommandResult)value;
            try {
                Log.getLogWriter().info("TestableGfsh saw ResultObject as follows: " + cr.getContent().toString());
                Log.getLogWriter().info("                                    size: " + cr.getContent().size());
                Log.getLogWriter().info("                                toString: " + cr.getContent().toString());
                Log.getLogWriter().info("                                   class: " + cr.getContent().getClass().getName());
                if (cr.getContent().size() == 0) {
                    return false;
                }
                StringBuffer checkForOutput = new StringBuffer();
                while (cr.hasNextLine()) {
                    String line = cr.nextLine();
                    checkForOutput.append(line);
                }
                String tmpStr = checkForOutput.toString();
                return tmpStr.trim().length() != 0;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return false;
    }

    private static String[] getPresentationString(TestableGfsh shell) {
        Map<String, Object> result = shell.getCommandOutput();
        StringBuffer presentationStr = new StringBuffer();
        StringBuffer errStr = new StringBuffer();
        for (String key : result.keySet()) {
            Object value = result.get(key);
            if (!(value instanceof CommandResult)) continue;
            CommandResult cr = (CommandResult)value;
            cr.resetToFirstLine();
            while (cr.hasNextLine()) {
                String line = cr.nextLine();
                presentationStr.append(line).append("\n");
            }
        }
        return new String[]{presentationStr.toString(), errStr.toString()};
    }

    private static String checkForRightPadding(String aStr) {
        Log.getLogWriter().info("Checking for white space for line: \"" + aStr + "\"");
        String[] tokens = aStr.split("\n");
        StringBuffer errStr = new StringBuffer();
        block0: for (String line : tokens) {
            int whiteSpaceCount = 0;
            for (int i = line.length() - 1; i >= 0; --i) {
                char ch = line.charAt(i);
                if (Character.isWhitespace(ch)) {
                    ++whiteSpaceCount;
                    if (i != 0) continue;
                    errStr.append("\"" + line + "\" contains " + whiteSpaceCount + " white space characters on the right\n");
                    continue;
                }
                if (whiteSpaceCount <= 0) continue block0;
                errStr.append("\"" + line + "\" contains " + whiteSpaceCount + " white space characters on the right\n");
                continue block0;
            }
        }
        return errStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logCommandOutput(TestableGfsh shell, PrintWriter commandOutputFile, String command, String output, String errStr) {
        StringBuffer logStr = new StringBuffer();
        logStr.append("================================================================================\n");
        logStr.append("" + new Date() + " vm_" + RemoteTestModule.getMyVmid() + ", thr_" + RemoteTestModule.getCurrentThread().getThreadId() + ", pid " + RemoteTestModule.getMyPid());
        logStr.append("\nCommand: \"" + command + "\"\n");
        if (shell.isConnectedAndReady()) {
            logStr.append("Connected  to: \"" + shell.getOperationInvoker().toString() + "\"\n");
        } else {
            logStr.append("Connected  : \"No\"\n");
        }
        logStr.append("Context Path: \"" + shell.getEnvProperty("APP_CONTEXT_PATH") + "\"\n");
        logStr.append("Fetch Size: \"" + shell.getEnvProperty("APP_FETCH_SIZE") + "\"\n");
        logStr.append("Query Result Display Mode: \"" + shell.getEnvProperty("APP_QUERY_RESULTS_DISPLAY_MODE") + "\"\n");
        logStr.append("Query Collection Limit: \"" + shell.getEnvProperty("APP_COLLECTION_LIMIT") + "\"\n");
        logStr.append("Last Exist Status: \"" + shell.getEnvProperty("APP_LAST_EXIT_STATUS") + "\"\n");
        logStr.append("Output (starts at beginnning of next line), output length is " + output.length() + ":\n" + output + "<--end of output\n");
        if (errStr.length() > 0) {
            logStr.append(errStr + "\n");
        }
        logStr.append("\n");
        Class<CLITest> clazz = CLITest.class;
        synchronized (CLITest.class) {
            commandOutputFile.print(logStr.toString());
            commandOutputFile.flush();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") == -1 && useVirtualTerm) {
            System.setProperty("jline.terminal", VirtualUnixTerminal.class.getCanonicalName());
        }
        if (System.getProperty("gfsh.disable.color") == null) {
            System.setProperty("gfsh.disable.color", "true");
        }
        System.setProperty("APP_QUIET_EXECUTION", "true");
    }

    static class TestableGfshConfig
    extends GfshConfig {
        private File parentDir;
        private String fileNamePrefix;
        private String name;
        private String generatedHistoryFileName;

        public TestableGfshConfig(String name) {
            CliUtil.isGfshVM = true;
            this.generatedHistoryFileName = null;
            this.name = name;
            if (TestableGfshConfig.isDUnitTest(this.name)) {
                this.fileNamePrefix = this.name;
            } else {
                try {
                    this.fileNamePrefix = RemoteTestModule.getMyClientName();
                }
                catch (Exception e) {
                    this.fileNamePrefix = "non-hydra-client";
                }
            }
            this.parentDir = new File("gfsh_files");
            this.parentDir.mkdirs();
        }

        private static boolean isDUnitTest(String name) {
            String[] split;
            boolean isDUnitTest = false;
            if (name != null && (split = name.split("_")).length != 0 && split[0].endsWith("DUnitTest")) {
                isDUnitTest = true;
            }
            return isDUnitTest;
        }

        public String getLogFilePath() {
            return new File(this.parentDir, this.getFileNamePrefix() + "-gfsh.log").getAbsolutePath();
        }

        private String getFileNamePrefix() {
            String timeStamp = new Time(System.currentTimeMillis()).toString();
            timeStamp = timeStamp.replace(':', '_');
            return this.fileNamePrefix + "-" + timeStamp;
        }

        public String getHistoryFileName() {
            if (this.generatedHistoryFileName == null) {
                String fileName;
                this.generatedHistoryFileName = fileName = new File(this.parentDir, this.getFileNamePrefix() + "-gfsh.history").getAbsolutePath();
                return fileName;
            }
            return this.generatedHistoryFileName;
        }

        public boolean isTestConfig() {
            return true;
        }

        public Level getLogLevel() {
            return Level.FINE;
        }
    }
}

