/*
 * Decompiled with CFR 0.152.
 */
package management.jmx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;

public class Expectation
implements Serializable {
    private static final long serialVersionUID = -7950183141936995134L;
    private ObjectName objectName;
    private String url;
    private List<ExpectedNotification> notifications = new ArrayList<ExpectedNotification>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> operations = new HashMap<String, Object>();
    public static final int MATCH_NOTIFICATION_SOURCE_AND_MESSAGE = 0;
    public static final int MATCH_NOTIFICATION_MESSAGE = 1;
    public static final int MATCH_NOTIFICATION_MESSAGECONTAINS_COUNT = 5;
    public static final int MATCH_NOTIFICATION_SOURCE_AND_USERDATA = 2;
    public static final int MATCH_NOTIFICATION_SOURCE_AND_MESSAGECONTAINS = 4;

    public Expectation(ObjectName mbean) {
        this.objectName = mbean;
    }

    public Expectation expectNotification(String notificationType, Object source, String message, int matchCount, int mode) {
        ExpectedNotification e = new ExpectedNotification();
        e.timestamp = System.currentTimeMillis();
        e.source = source;
        e.userData = null;
        e.matchCount = matchCount;
        e.type = notificationType;
        e.message = message;
        e.matchMode = mode;
        this.notifications.add(e);
        Collections.sort(this.notifications, new Comparator<ExpectedNotification>(){

            @Override
            public int compare(ExpectedNotification o1, ExpectedNotification o2) {
                return (int)(o1.timestamp - o2.timestamp);
            }
        });
        return this;
    }

    public Expectation expectNotification(String notificationType, Object source, String message, Object userData, int mode) {
        ExpectedNotification e = new ExpectedNotification();
        e.timestamp = System.currentTimeMillis();
        e.source = source;
        e.userData = userData;
        e.type = notificationType;
        e.message = message;
        e.matchMode = mode;
        this.notifications.add(e);
        Collections.sort(this.notifications, new Comparator<ExpectedNotification>(){

            @Override
            public int compare(ExpectedNotification o1, ExpectedNotification o2) {
                return (int)(o1.timestamp - o2.timestamp);
            }
        });
        return this;
    }

    public Expectation expectMBeanAt(String url) {
        this.url = url;
        return this;
    }

    public Expectation expectAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public Expectation expectOperation(String operationName, Object result) {
        this.operations.put(operationName, result);
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public List<ExpectedNotification> getNotifications() {
        return this.notifications;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getOperations() {
        return this.operations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.objectName != null) {
            sb.append("[ ON : " + this.objectName.toString());
        }
        sb.append(" URL : ").append(this.url);
        sb.append("\n notifications : ").append(this.notifications);
        sb.append(" attributes : ").append(this.attributes.keySet());
        sb.append(" operations : ").append(this.operations.keySet());
        sb.append(" ]");
        return sb.toString();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public ObjectName getObjectName(String url2) {
        return this.objectName;
    }

    public static class ExpectedNotification {
        public long timestamp;
        public Object userData;
        public Object source;
        public String type;
        public String message;
        public int matchMode;
        public int matchCount = -1;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Expected Notif [ Type ").append(this.type).append(" source : ").append(this.source).append(" message : ").append(this.message).append(" matchCount : ").append(this.matchCount).append(" userData : ").append(this.userData).append(" timestamp : ").append(this.timestamp).append(" ]");
            return sb.toString();
        }
    }
}

