/*
 * Decompiled with CFR 0.152.
 */
package management.jmx;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.DiskStoreMXBean;
import com.gemstone.gemfire.management.DistributedLockServiceMXBean;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.GatewayReceiverMXBean;
import com.gemstone.gemfire.management.GatewaySenderMXBean;
import com.gemstone.gemfire.management.LockServiceMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import management.jmx.JMXPrms;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class GemfireMBeanServerConnection
implements MBeanServerConnection {
    private static final Pattern distributedLockservicePattern = Pattern.compile("GemFire:service=LockService,name=(.*),type=Distributed");
    private static final Pattern distributedRegionPattern = Pattern.compile("GemFire:service=Region,name=(.*),type=Distributed");
    private static final Pattern memberPattern = Pattern.compile("GemFire:type=Member,member=(.*)");
    private static final Pattern regionPattern = Pattern.compile("GemFire:service=Region,name=(.*),type=(.*),member=(.*)");
    private static final Pattern diskStorePattern = Pattern.compile("GemFire:service=DiskStore,name=(.*),type=(.*),member=(.*)");
    private static final Pattern lockservicePattern = Pattern.compile("GemFire:service=LockService,name=(.*),type=(.*),member=(.*)");
    private static final Pattern gwSenderPattern = Pattern.compile("GemFire:service=GatewaySender,gatewaySender=(.*),type=(.*),member=(.*)");
    private static final Pattern gwReceiverPattern = Pattern.compile("GemFire:service=GatewayReceiver,type=(.*),member=(.*)");
    private static final Pattern cacheServerPattern = Pattern.compile("GemFire:service=CacheServer,port=(.*),type=(.*),member=(.*)");
    private SystemManagementService service = null;

    public GemfireMBeanServerConnection(ManagementService service) {
        this.service = (SystemManagementService)service;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        return server.queryMBeans(name, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        return server.queryNames(name, query);
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public String getDefaultDomain() throws IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public String[] getDomains() throws IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        server.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        server.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        server.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        server.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        server.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MBeanServerConnection server = ManagementUtil.getPlatformMBeanServer();
        server.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("GemfireMBeanServerConnection does not implement this opeation ");
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if (!this.service.isManager()) {
            throw new TestException("This node does not run Federating manager. Wrong test Configuration");
        }
        if (!JMXPrms.useGemfireProxies()) {
            throw new TestException("useGemfireProxies is false but still gemfireMBeanServerConnection is called ");
        }
        Object proxy = this.getProxy(name);
        try {
            Object methodResult = GemfireMBeanServerConnection.execMethodOnObject(operationName, params, signature, proxy);
            return methodResult;
        }
        catch (SecurityException e) {
            HydraUtil.logErrorAndRaiseException("Error running method " + operationName + " on mbean-proxy " + name, e);
        }
        catch (IllegalArgumentException e) {
            HydraUtil.logErrorAndRaiseException("Error running method " + operationName + " on mbean-proxy " + name, e);
        }
        catch (ClassNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error running method " + operationName + " on mbean-proxy " + name, e);
        }
        catch (NoSuchMethodException e) {
            HydraUtil.logErrorAndRaiseException("Error running method " + operationName + " on mbean-proxy " + name, e);
        }
        catch (IllegalAccessException e) {
            HydraUtil.logErrorAndRaiseException("Error running method " + operationName + " on mbean-proxy " + name, e);
        }
        catch (InvocationTargetException e) {
            HydraUtil.logErrorAndRaiseException("Error running method " + operationName + " on mbean-proxy " + name, e);
        }
        return null;
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        if (!this.service.isManager()) {
            throw new TestException("This node does not run Federating manager. Wrong test Configuration");
        }
        if (!JMXPrms.useGemfireProxies()) {
            throw new TestException("useGemfireProxies is false but still gemfireMBeanServerConnection is called ");
        }
        Object proxy = this.getProxy(name);
        try {
            Object returnValue = GemfireMBeanServerConnection.getter(attribute, proxy);
            return returnValue;
        }
        catch (SecurityException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (IllegalArgumentException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (NoSuchMethodException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (IllegalAccessException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (InvocationTargetException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        return null;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        if (!this.service.isManager()) {
            throw new TestException("This node does not run Federating manager. Wrong test Configuration");
        }
        if (!JMXPrms.useGemfireProxies()) {
            throw new TestException("useGemfireProxies is false but still gemfireMBeanServerConnection is called ");
        }
        AttributeList list = new AttributeList();
        Object proxy = this.getProxy(name);
        for (String attr : attributes) {
            try {
                Object returnValue = GemfireMBeanServerConnection.getter(attr, proxy);
                list.add(new Attribute(attr, returnValue));
            }
            catch (SecurityException e) {
                HydraUtil.logErrorAndRaiseException("Error running getter " + attr + " on mbean-proxy " + name, e);
            }
            catch (IllegalArgumentException e) {
                HydraUtil.logErrorAndRaiseException("Error running getter " + attr + " on mbean-proxy " + name, e);
            }
            catch (NoSuchMethodException e) {
                HydraUtil.logErrorAndRaiseException("Error running getter " + attr + " on mbean-proxy " + name, e);
            }
            catch (IllegalAccessException e) {
                HydraUtil.logErrorAndRaiseException("Error running getter " + attr + " on mbean-proxy " + name, e);
            }
            catch (InvocationTargetException e) {
                HydraUtil.logErrorAndRaiseException("Error running getter " + attr + " on mbean-proxy " + name, e);
            }
        }
        return list;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (!this.service.isManager()) {
            throw new TestException("This node does not run Federating manager. Wrong test Configuration");
        }
        if (!JMXPrms.useGemfireProxies()) {
            throw new TestException("useGemfireProxies is false but still gemfireMBeanServerConnection is called ");
        }
        Object proxy = this.getProxy(name);
        try {
            GemfireMBeanServerConnection.setter(attribute.getName(), proxy, attribute.getValue());
        }
        catch (SecurityException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (IllegalArgumentException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (NoSuchMethodException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (IllegalAccessException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
        catch (InvocationTargetException e) {
            HydraUtil.logErrorAndRaiseException("Error running getter " + attribute + " on mbean-proxy " + name, e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getProxy(ObjectName name) {
        void var3_23;
        void var3_21;
        String memberName;
        Matcher match;
        Class interfaceClass = this.getInerfaceClassFromObjectName(name);
        HydraUtil.logFine("Trying to locate proxy for objectName " + name + " with interfaceClass  " + interfaceClass);
        Object var3_3 = null;
        if (interfaceClass == null) {
            throw new TestException("Unknown objectname " + name.toString());
        }
        String thisMemberId = this.getMemberID();
        if (interfaceClass.equals(MemberMXBean.class)) {
            match = memberPattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(1);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local member mbean ");
                MemberMXBean memberMXBean = this.service.getMemberMXBean();
            }
        } else if (interfaceClass.equals(RegionMXBean.class)) {
            match = regionPattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(3);
            String regionName = match.group(1);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local region mbean for region " + regionName);
                RegionMXBean regionMXBean = this.service.getLocalRegionMBean(regionName);
            }
        } else if (interfaceClass.equals(DiskStoreMXBean.class)) {
            match = diskStorePattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(3);
            String diskStore = match.group(1);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local diskStore mbean for " + diskStore);
                DiskStoreMXBean diskStoreMXBean = this.service.getLocalDiskStoreMBean(diskStore);
            }
        } else if (interfaceClass.equals(LockServiceMXBean.class)) {
            match = lockservicePattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(3);
            String lock = match.group(1);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local lockService mbean for " + lock);
                LockServiceMXBean lockServiceMXBean = this.service.getLocalLockServiceMBean(lock);
            }
        } else if (interfaceClass.equals(GatewaySenderMXBean.class)) {
            match = gwSenderPattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(3);
            String sender = match.group(1);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local gwsender mbean " + sender);
                GatewaySenderMXBean gatewaySenderMXBean = this.service.getLocalGatewaySenderMXBean(sender);
            }
        } else if (interfaceClass.equals(GatewayReceiverMXBean.class)) {
            match = gwReceiverPattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(2);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local gwreceiver mbean ");
                GatewayReceiverMXBean gatewayReceiverMXBean = this.service.getLocalGatewayReceiverMXBean();
            }
        } else if (interfaceClass.equals(CacheServerMXBean.class)) {
            match = cacheServerPattern.matcher(name.toString());
            memberName = null;
            if (!match.find()) throw new TestException("Could not locate memberName from objectName : " + name.toString());
            memberName = match.group(3);
            String port = match.group(1);
            int serverPort = Integer.parseInt(port);
            HydraUtil.logFine("memberName from ON = <" + memberName + "> Local MemberId from API = " + thisMemberId);
            if (thisMemberId.equals(memberName)) {
                HydraUtil.logFine("Returning local cacheserver mbean");
                CacheServerMXBean cacheServerMXBean = this.service.getLocalCacheServerMXBean(serverPort);
            }
        } else if (interfaceClass.equals(DistributedLockServiceMXBean.class)) {
            HydraUtil.logFine("Trying to locate DistributedLockService named " + name);
            match = distributedLockservicePattern.matcher(name.toString());
            String lockServiceName = null;
            if (!match.find()) throw new TestException("Could not locate lockServiceName from objectName : " + name.toString());
            lockServiceName = match.group(1);
            DistributedLockServiceMXBean distributedLockServiceMXBean = this.service.getDistributedLockServiceMXBean(lockServiceName);
            HydraUtil.logFine("Located DistributedLockService named " + lockServiceName + " is " + distributedLockServiceMXBean);
        } else if (interfaceClass.equals(DistributedSystemMXBean.class)) {
            DistributedSystemMXBean distributedSystemMXBean = this.service.getDistributedSystemMXBean();
        } else if (interfaceClass.equals(DistributedRegionMXBean.class)) {
            match = distributedRegionPattern.matcher(name.toString());
            String regionPath = null;
            if (!match.find()) throw new TestException("Could not locate regionPath from objectName : " + name.toString());
            regionPath = match.group(1);
            DistributedRegionMXBean distributedRegionMXBean = this.service.getDistributedRegionMXBean(regionPath);
        }
        if (var3_21 == null) {
            Object object = this.service.getMBeanProxy(name, interfaceClass);
        }
        if (var3_23 != null) return var3_23;
        try {
            Set<ObjectName> allMbeans = this.queryNames(null, null);
            HashSet<ObjectName> fileteredON = new HashSet<ObjectName>();
            for (ObjectName n : allMbeans) {
                if (!n.toString().contains("GemFire")) continue;
                fileteredON.add(n);
            }
            HydraUtil.logInfo("Gemfire mbeans " + fileteredON);
            if (!fileteredON.contains(name)) throw new TestException("Proxy for " + name + " could not be located");
            throw new TestException("MBeanServer contains MBean for " + name + " but Mgmt Service does not return" + " proxy for it");
        }
        catch (IOException e) {
            throw new TestException("Error querying mbeans", e);
        }
    }

    private String getMemberID() {
        String formattedMemberID = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        return formattedMemberID;
    }

    private static Object execMethodOnObject(String operationName, Object[] params, String[] signature, Object target) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> klass = target.getClass();
        Class[] parameterTypes = null;
        if (signature != null) {
            parameterTypes = new Class[signature.length];
            int i = 0;
            for (String p : signature) {
                parameterTypes[i++] = GemfireMBeanServerConnection.getPrimitiveClassOrOrigClass(p);
            }
        }
        Method method = klass.getMethod(operationName, parameterTypes);
        return method.invoke(target, params);
    }

    private static Class getPrimitiveClassOrOrigClass(String p) throws ClassNotFoundException {
        if ("int".equals(p)) {
            return Integer.TYPE;
        }
        if ("byte".equals(p)) {
            return Byte.TYPE;
        }
        if ("short".equals(p)) {
            return Short.TYPE;
        }
        if ("long".equals(p)) {
            return Long.TYPE;
        }
        if ("float".equals(p)) {
            return Float.TYPE;
        }
        if ("double".equals(p)) {
            return Double.TYPE;
        }
        if ("boolean".equals(p)) {
            return Boolean.TYPE;
        }
        return Class.forName(p);
    }

    private static void setter(String attributeName, Object target, Object attributeValue) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> klass = target.getClass();
        Class[] parameterTypes = new Class[]{attributeValue.getClass()};
        Object[] params = new Object[]{attributeValue};
        String operationName = "set" + attributeName;
        Method method = null;
        try {
            method = klass.getMethod(operationName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            parameterTypes[0] = GemfireMBeanServerConnection.getPrimitveClassType(parameterTypes[0]);
            method = klass.getMethod(operationName, parameterTypes);
        }
        method.invoke(target, params);
    }

    private static Class getPrimitveClassType(Class klass) {
        if (klass.isAssignableFrom(Byte.class)) {
            return Byte.TYPE;
        }
        if (klass.isAssignableFrom(Short.class)) {
            return Short.TYPE;
        }
        if (klass.isAssignableFrom(Integer.class)) {
            return Integer.TYPE;
        }
        if (klass.isAssignableFrom(Long.class)) {
            return Long.TYPE;
        }
        if (klass.isAssignableFrom(Float.class)) {
            return Float.TYPE;
        }
        if (klass.isAssignableFrom(Double.class)) {
            return Double.TYPE;
        }
        if (klass.isAssignableFrom(Boolean.class)) {
            return Boolean.TYPE;
        }
        return null;
    }

    private static Object getter(String attributeName, Object target) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> klass = target.getClass();
        Class<?>[] parameterTypes = null;
        Object[] params = null;
        String operationName = "get" + attributeName;
        Method method = null;
        try {
            method = klass.getMethod(operationName, parameterTypes);
        }
        catch (NoSuchMethodException ne) {
            HydraUtil.logInfo("Cound not find getter " + operationName + " now trying for boolean getter is" + attributeName);
            operationName = "is" + attributeName;
            method = klass.getMethod(operationName, parameterTypes);
            HydraUtil.logInfo("Getter - " + operationName + " is" + method);
        }
        try {
            Object result = method.invoke(target, params);
            HydraUtil.logInfo("Getter - " + operationName + " result " + result);
            return result;
        }
        catch (Exception e) {
            HydraUtil.logErrorAndRaiseException("Error for getter " + attributeName, e);
            return null;
        }
    }

    private Class getInerfaceClassFromObjectName(ObjectName name) {
        String str = name.toString();
        if (str.startsWith("GemFire:service=CacheServer")) {
            return CacheServerMXBean.class;
        }
        if (str.startsWith("GemFire:service=DiskStore")) {
            return DiskStoreMXBean.class;
        }
        if (str.startsWith("GemFire:service=LockService")) {
            if (str.contains("Distributed")) {
                return DistributedLockServiceMXBean.class;
            }
            return LockServiceMXBean.class;
        }
        if (str.startsWith("GemFire:service=Region")) {
            if (str.contains("Distributed")) {
                return DistributedRegionMXBean.class;
            }
            return RegionMXBean.class;
        }
        if (str.startsWith("GemFire:service=System,type=Distributed")) {
            return DistributedSystemMXBean.class;
        }
        if (str.startsWith("GemFire:service=GatewayReceiver")) {
            return GatewayReceiverMXBean.class;
        }
        if (str.startsWith("GemFire:service=GatewaySender")) {
            return GatewaySenderMXBean.class;
        }
        if (str.startsWith("GemFire:type=Member")) {
            return MemberMXBean.class;
        }
        return null;
    }
}

