/*
 * Decompiled with CFR 0.152.
 */
package management.jmx;

import com.gemstone.gemfire.LogWriter;
import hydra.Log;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import management.jmx.Expectation;
import management.jmx.JMXEvent;
import management.jmx.JMXEventRecorder;
import management.util.HydraUtil;

public class JMXBlackboard
extends Blackboard
implements JMXEventRecorder {
    public static final String MBEAN_MAP = "MBEAN_MAP";
    static String CONNECTOR_URL_LIST = "CONNECTOR_URL_MAP";
    static String JMX_EVENTS = "JMX_EVENTS";
    static String JMX_EXPECTED_STATE = "JMX_EXPECTED_STATE";
    public static String REGION_DELETE_LIST = "REGION_DELETE_LIST";
    static String BB_NAME = "JMX_Blackboard";
    static String BB_TYPE = "RMI";
    private static JMXBlackboard bbInstance = null;
    public static int VM_TASKS_COMPLETE_COUNT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JMXBlackboard getBB() {
        if (bbInstance != null) return bbInstance;
        Class<JMXBlackboard> clazz = JMXBlackboard.class;
        synchronized (JMXBlackboard.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new JMXBlackboard(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public JMXBlackboard() {
    }

    public JMXBlackboard(String name, String type) {
        super(name, type, JMXBlackboard.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRMIPort(String clientName, String url) {
        JMXBlackboard jMXBlackboard = this;
        synchronized (jMXBlackboard) {
            Map map = (Map)this.getSharedMap().get(CONNECTOR_URL_LIST);
            map.put(clientName, url);
            this.getSharedMap().put(CONNECTOR_URL_LIST, map);
        }
    }

    public String getRandomClient() {
        LogWriter logger = Log.getLogWriter();
        Map map = (Map)this.getSharedMap().get(CONNECTOR_URL_LIST);
        if (map.size() > 0) {
            Random r = new Random();
            int randomKey = r.nextInt(map.size());
            Set keys = map.keySet();
            Object[] keysarray = keys.toArray();
            String clientName = (String)keysarray[randomKey];
            logger.info("URL for client " + clientName + " is " + (String)map.get(clientName));
            String url = (String)map.get(clientName);
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addEvent(JMXEvent event) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            ArrayList list = (ArrayList)this.getSharedMap().get(JMX_EVENTS);
            list.add(event);
            this.getSharedMap().put(JMX_EVENTS, list);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addExpectation(Expectation ex) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            ArrayList list = (ArrayList)this.getSharedMap().get(JMX_EXPECTED_STATE);
            list.add(ex);
            this.getSharedMap().put(JMX_EXPECTED_STATE, list);
        }
        finally {
            lock.unlock();
        }
    }

    public static void JMXBlackboard_Init() {
        JMXBlackboard.getBB().initBlackBoard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initBlackBoard() {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            if (!JMXBlackboard.getBB().getSharedMap().containsKey(CONNECTOR_URL_LIST)) {
                JMXBlackboard.getBB().getSharedMap().put(CONNECTOR_URL_LIST, new HashMap());
            }
            if (!JMXBlackboard.getBB().getSharedMap().containsKey(JMX_EVENTS)) {
                JMXBlackboard.getBB().getSharedMap().put(JMX_EVENTS, new ArrayList());
            }
            if (!JMXBlackboard.getBB().getSharedMap().containsKey(JMX_EXPECTED_STATE)) {
                JMXBlackboard.getBB().getSharedMap().put(JMX_EXPECTED_STATE, new ArrayList());
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public List<JMXEvent> getRecordedEvents() {
        return (ArrayList)this.getSharedMap().get(JMX_EVENTS);
    }

    public List<Expectation> getExpectedState() {
        return (ArrayList)this.getSharedMap().get(JMX_EXPECTED_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMap(String key, Map map) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            SharedMap smap = this.getSharedMap();
            int size = smap.size();
            int newSize = map.size();
            if (size != newSize) {
                smap.put(key, map);
                HydraUtil.logInfo("Updating map for key " + key + " old Map : " + smap + " new Map : " + map);
            } else {
                HydraUtil.logInfo("Not Updating map for key " + key + " since size is matching. old Map : " + smap + " new Map : " + map);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToList(String list, Object object) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            ArrayList<Object> bbList = (ArrayList<Object>)JMXBlackboard.getBB().getSharedMap().get(list);
            if (bbList == null) {
                bbList = new ArrayList<Object>();
            }
            bbList.add(object);
            JMXBlackboard.getBB().getSharedMap().put(list, bbList);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getList(String list) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            List bbList = (List)JMXBlackboard.getBB().getSharedMap().get(list);
            if (bbList == null) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            List list2 = bbList;
            return list2;
        }
        finally {
            lock.unlock();
        }
    }

    public Map getMap(String key) {
        return (Map)this.getSharedMap().get(key);
    }
}

