/*
 * Decompiled with CFR 0.152.
 */
package management.jmx;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import management.jmx.JMXBlackboard;
import management.jmx.JMXEventRecorder;
import management.jmx.JMXNotification;
import management.util.HydraUtil;
import util.TestException;

public class JMXNotificationListener
implements NotificationListener {
    private JMXEventRecorder recorder = null;
    private ObjectName objectName = null;
    private String filterBasedonSource = null;
    private boolean applyFilter = false;
    private String prefix = null;

    public void setFilterBasedonSource(boolean filterBasedonSource) {
        this.applyFilter = true;
    }

    public JMXNotificationListener(String prefix, JMXEventRecorder recorder, ObjectName name) {
        this.recorder = recorder;
        this.objectName = name;
        this.prefix = prefix;
    }

    public JMXNotificationListener(String prefix, JMXEventRecorder recorder, ObjectName name, String filter) {
        this.recorder = recorder;
        this.objectName = name;
        this.filterBasedonSource = filter;
        this.applyFilter = true;
        this.prefix = prefix;
    }

    public JMXNotificationListener() {
        this.recorder = JMXBlackboard.getBB();
        this.prefix = "<<UNNAMED>>";
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        try {
            boolean filterOrNot;
            boolean bl = filterOrNot = !this.applyFilter || this.applyFilter && this.filterBasedonSource.equals(notification.getSource());
            if (filterOrNot) {
                HydraUtil.logInfo("JMXNotificationListener(" + this.prefix + ") : Received JMX Notification " + notification.getType() + " from " + notification.getSource() + " for " + this.objectName);
                this.printJMXNotification(notification, handback);
                JMXNotification blackboardNotificaton = new JMXNotification(notification, handback, this.objectName);
                this.recorder.addEvent(blackboardNotificaton);
            } else {
                HydraUtil.logInfo("JMXNotificationListener(" + this.prefix + ") : Filtered Notification " + notification.getType() + " from " + notification.getSource() + " for " + this.objectName);
            }
        }
        catch (Exception e) {
            throw new TestException("Notification Listener error", e);
        }
    }

    private void printJMXNotification(Notification notification, Object handback) {
        StringBuilder sb = new StringBuilder();
        sb.append("JMXNotificationListener(" + this.prefix + ") : Notification [ type=").append(notification.getType()).append(", message=").append(notification.getMessage()).append(", source=").append(notification.getSource()).append(", seqNo=").append(notification.getSequenceNumber()).append(", timestamp=").append(notification.getTimeStamp()).append(", data=").append(HydraUtil.ObjectToString(notification.getUserData())).append(", handbackObject=").append(HydraUtil.ObjectToString(handback)).append(" ]");
        HydraUtil.logInfo(sb.toString());
    }
}

