/*
 * Decompiled with CFR 0.152.
 */
package management.jmx.validation;

import javax.management.ObjectName;
import management.jmx.validation.JMXValidationError;
import management.util.HydraUtil;

public class ValidationResult {
    private static final String NEW_LINE = System.getProperty("line.separator");
    public String url;
    public String attribute;
    boolean isError;
    public Throwable error;
    public String operationName;
    public Object value;
    public Object expectedValue;
    public Object result;
    public Object expectedResult;
    public JMXValidationError errorType;
    public String message;
    public ObjectName objectName;
    public String notification;

    public static ValidationResult missingNotification(ObjectName name, String url, String notification, String message) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.errorType = JMXValidationError.NOTIFICATION_MISSING;
        result.message = "Error missing notification - " + message;
        result.notification = notification;
        return result;
    }

    public static ValidationResult mbeanNotFound(ObjectName name, String url) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.errorType = JMXValidationError.MBEAN_NOT_FOUND;
        return result;
    }

    public static ValidationResult attributeDontMatch(ObjectName name, String url, String atr, Object value, Object expectedValue) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.errorType = JMXValidationError.ATTRIBUTE_NOT_MATCHED;
        result.attribute = atr;
        result.value = value;
        result.expectedValue = expectedValue;
        return result;
    }

    public static ValidationResult operationResultedInError(ObjectName name, String url, String operation, Throwable error) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.errorType = JMXValidationError.OPERATION_ERROR;
        result.operationName = operation;
        result.error = error;
        result.isError = true;
        return result;
    }

    public static ValidationResult operationResultUnExpected(ObjectName name, String url, String operation, Object opResult, Object expected) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.errorType = JMXValidationError.OPERATION_RESULT_UNEXPECTED;
        result.operationName = operation;
        result.expectedResult = expected;
        result.result = opResult;
        return result;
    }

    public static ValidationResult jmxError(ObjectName name, String url, Throwable t) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.isError = true;
        result.error = t;
        result.errorType = JMXValidationError.JMX_ERROR;
        return result;
    }

    public static ValidationResult error(ObjectName name, String url, String message) {
        ValidationResult result = new ValidationResult();
        result.objectName = name;
        result.url = url;
        result.errorType = JMXValidationError.USER_ERROR;
        result.message = message;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.errorType.equals((Object)JMXValidationError.ATTRIBUTE_NOT_MATCHED)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" attribute : ").append(this.attribute).append(" value : ").append(this.value).append(" expectedValue : ").append(this.expectedValue).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.OPERATION_ERROR)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" operation : ").append(this.operationName).append(" errorString : ").append(this.error.getMessage()).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(NEW_LINE).append(" StackTrace ").append(HydraUtil.getStackTraceAsString(this.error)).append(NEW_LINE).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.MBEAN_NOT_FOUND)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.OPERATION_RESULT_UNEXPECTED)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" operation : ").append(this.operationName).append(" expectedResult : ").append(this.expectedResult).append(" result : ").append(this.result).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.NOTIFICATION_MISSING)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" message : ").append(this.message).append(" notification : ").append(this.notification).append(" objectName : ").append(" url : ").append(this.url);
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.NOTIFICATION_UNEXPECTED)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" value : ").append(this.value).append(" expectedValue : ").append(this.expectedValue).append(" attribute : ").append(this.attribute).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.JMX_ERROR)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" error : ").append(this.error.getMessage()).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(NEW_LINE).append(" StackTrace ").append(HydraUtil.getStackTraceAsString(this.error)).append(NEW_LINE).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.JAVA_ERROR)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" value : ").append(this.value).append(" expectedValue : ").append(this.expectedValue).append(" attribute : ").append(this.attribute).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(NEW_LINE).append(" StackTrace ").append(HydraUtil.getStackTraceAsString(this.error)).append(NEW_LINE).append(" ");
            return sb.toString();
        }
        if (this.errorType.equals((Object)JMXValidationError.USER_ERROR)) {
            sb.append(" REASON : ").append((Object)this.errorType).append(" message : ").append(this.message).append(" objectName : ").append(this.objectName).append(" url : ").append(this.url).append(NEW_LINE).append(" StackTrace ").append(HydraUtil.getStackTraceAsString(this.error)).append(NEW_LINE).append(" ");
            return sb.toString();
        }
        return null;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public ValidationResult objectName(ObjectName objectName) {
        this.objectName = objectName;
        return this;
    }
}

