/*
 * Decompiled with CFR 0.152.
 */
package management.operations.events.impl;

import hydra.RemoteTestModule;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import management.operations.OperationEvent;
import management.operations.OperationsBlackboard;
import management.operations.events.impl.CQAndIndexEvents;
import management.operations.events.impl.DLockEvents;
import management.operations.events.impl.EntryEvents;
import management.operations.events.impl.FunctionEvents;
import management.operations.events.impl.RegionEvents;
import management.operations.events.impl.RegionQueryEvents;
import management.operations.events.impl.TransactionEvents;
import management.util.HydraUtil;

public class AbstractEvents {
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    protected Lock readLock = this.lock.readLock();
    protected Lock writeLock = this.lock.writeLock();
    protected Map<String, List<OperationEvent>> eventMap = new HashMap<String, List<OperationEvent>>();

    public AbstractEvents(Map<String, List<OperationEvent>> eventMap) {
        this.eventMap = eventMap;
    }

    public AbstractEvents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(OperationEvent event) {
        this.writeLock.lock();
        try {
            String name = event.name;
            List<Object> list = null;
            if (this.eventMap.containsKey(name)) {
                list = this.eventMap.get(name);
            } else {
                list = new ArrayList();
                this.eventMap.put(name, list);
                this.processIndexes(event);
            }
            list.add(event);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(List<OperationEvent> events) {
        this.writeLock.lock();
        try {
            for (OperationEvent event : events) {
                String name = event.name;
                List<Object> list = null;
                if (this.eventMap.containsKey(name)) {
                    list = this.eventMap.get(name);
                } else {
                    list = new ArrayList();
                    this.eventMap.put(name, list);
                    this.processIndexes(event);
                }
                list.add(event);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void processIndexes(OperationEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OperationEvent>> getAllEvents() {
        this.readLock.lock();
        try {
            Map<String, List<OperationEvent>> map = this.eventMap;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperationEvent> getEvents(String name) {
        this.readLock.lock();
        try {
            List<OperationEvent> list = this.eventMap.get(name);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEvents() {
        this.writeLock.lock();
        try {
            this.eventMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToBlackBoard(Blackboard bb) {
        long l1 = System.currentTimeMillis();
        HydraUtil.logInfo("Upating blackboard with events  " + this.eventMap.keySet() + " kinds");
        this.readLock.lock();
        SharedLock lock = bb.getSharedLock();
        try {
            lock.lock();
            HashMap globalEventMap = (HashMap)bb.getSharedMap().get("EVENT_LIST");
            if (globalEventMap == null) {
                globalEventMap = new HashMap();
            }
            int eventCount = 0;
            String thisVM = RemoteTestModule.getMyClientName();
            HashMap localEvents = (HashMap)globalEventMap.get(thisVM);
            if (localEvents == null) {
                localEvents = new HashMap();
            }
            for (String key : this.eventMap.keySet()) {
                ArrayList<OperationEvent> list = (ArrayList<OperationEvent>)localEvents.get(key);
                if (list == null) {
                    list = new ArrayList<OperationEvent>();
                }
                List<OperationEvent> localList = this.eventMap.get(key);
                eventCount += localList.size();
                HydraUtil.logInfo("Adding events of type " + key + " total events " + localList.size());
                list.addAll(localList);
                localEvents.put(key, list);
            }
            globalEventMap.put(thisVM, localEvents);
            bb.getSharedMap().put("EVENT_LIST", globalEventMap);
            HydraUtil.logInfo("Total events added to blackboard " + eventCount);
            long l2 = System.currentTimeMillis();
            HydraUtil.logInfo("Total time to add events " + (l2 - l1) + " ms.");
        }
        finally {
            lock.unlock();
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AbstractEvents> importFromBlackBoard(String type, Blackboard bb) {
        long l1 = System.currentTimeMillis();
        HydraUtil.logInfo("Importing blackboard with events  " + type + " kinds");
        SharedLock lock = bb.getSharedLock();
        try {
            lock.lock();
            Map globalEventMap = (Map)bb.getSharedMap().get("EVENT_LIST");
            HashMap<String, AbstractEvents> eventMap = new HashMap<String, AbstractEvents>();
            int eventCount = 0;
            boolean clientCount = false;
            for (String clientName : globalEventMap.keySet()) {
                Map localEvents = (Map)globalEventMap.get(clientName);
                AbstractEvents events = AbstractEvents.getEventImplOfType(localEvents, type);
                eventMap.put(clientName, events);
                eventCount += events.getNumberOfEvents();
                HydraUtil.logInfo("Total events imported from blackboard " + events.getNumberOfEvents() + " for client " + clientName);
            }
            HydraUtil.logInfo("Total events imported from blackboard " + eventCount);
            long l2 = System.currentTimeMillis();
            HydraUtil.logInfo("Total time to import events " + (l2 - l1) + " ms.");
            HashMap<String, AbstractEvents> hashMap = eventMap;
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractEvents importFromBlackBoard(String type, String clientName, Blackboard bb) {
        long l1 = System.currentTimeMillis();
        HydraUtil.logInfo("Importing blackboard with events  " + type + " kinds");
        SharedLock lock = bb.getSharedLock();
        try {
            lock.lock();
            Map globalEventMap = (Map)bb.getSharedMap().get("EVENT_LIST");
            HashMap eventMap = new HashMap();
            int eventCount = 0;
            boolean clientCount = false;
            Map localEvents = (Map)globalEventMap.get(clientName);
            AbstractEvents events = AbstractEvents.getEventImplOfType(localEvents, type);
            HydraUtil.logInfo("Total events imported from blackboard " + events.getNumberOfEvents() + " for client " + clientName);
            HydraUtil.logInfo("Total events imported from blackboard " + (eventCount += events.getNumberOfEvents()));
            long l2 = System.currentTimeMillis();
            HydraUtil.logInfo("Total time to import events " + (l2 - l1) + " ms.");
            AbstractEvents abstractEvents = events;
            return abstractEvents;
        }
        finally {
            lock.unlock();
        }
    }

    private static AbstractEvents getEventImplOfType(Map<String, List<OperationEvent>> localEvents, String type) {
        HashMap<String, List<OperationEvent>> eventMap = new HashMap<String, List<OperationEvent>>();
        List<OperationEvent> list = localEvents.get(type);
        ArrayList<OperationEvent> newList = new ArrayList<OperationEvent>();
        if (list != null) {
            for (OperationEvent e : list) {
                newList.add(e);
            }
        }
        eventMap.put(type, newList);
        AbstractEvents events = null;
        if (type.contains("REGION")) {
            events = new RegionEvents(eventMap);
        } else if (type.contains("CQ") || type.contains("INDEX")) {
            events = new CQAndIndexEvents(eventMap);
        } else if (type.contains("ENTRY")) {
            events = new EntryEvents(eventMap);
        } else if (type.contains("FUNCT")) {
            events = new FunctionEvents(eventMap);
        } else if (type.contains("QUERY")) {
            events = new RegionQueryEvents(eventMap);
        } else if (type.contains("TX")) {
            events = new TransactionEvents(eventMap);
        } else if (type.contains("DLOCK")) {
            events = new DLockEvents(eventMap);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfEvents() {
        this.readLock.lock();
        try {
            int total = 0;
            for (List<OperationEvent> list : this.eventMap.values()) {
                total += list.size();
            }
            int n = total;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void printEvents() {
        HydraUtil.logInfo("Printing all events ");
        for (String eventType : this.eventMap.keySet()) {
            HydraUtil.logInfo("Printing " + eventType + " events : ");
            List<OperationEvent> list = this.eventMap.get(eventType);
            for (OperationEvent e : list) {
                HydraUtil.logInfo("E:" + e.name + ", data: " + HydraUtil.ObjectToString(e.data));
            }
        }
        HydraUtil.logInfo("Finished with Printing all events ");
    }

    public static List<Object> getUniqueEventsForClient(String givenClientName, String kind) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        AbstractEvents ae = AbstractEvents.importFromBlackBoard(kind, givenClientName, OperationsBlackboard.getBB());
        if (ae != null) {
            List<OperationEvent> opList = ae.getEvents(kind);
            for (OperationEvent oe : opList) {
                String eventName = (String)oe.data;
                if (objectList.contains(eventName)) continue;
                objectList.add(oe.data);
            }
        }
        return objectList;
    }

    public static List<Object> getUniqueEventsAcrossAll(String kind) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        Map<String, AbstractEvents> emap = AbstractEvents.importFromBlackBoard(kind, OperationsBlackboard.getBB());
        if (emap != null) {
            for (Map.Entry<String, AbstractEvents> e : emap.entrySet()) {
                AbstractEvents ae = e.getValue();
                List<OperationEvent> opList = ae.getEvents(kind);
                for (OperationEvent oe : opList) {
                    String eventName = (String)oe.data;
                    if (objectList.contains(eventName)) continue;
                    objectList.add(oe.data);
                }
            }
        }
        return objectList;
    }
}

