/*
 * Decompiled with CFR 0.152.
 */
package management.operations.events.impl;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.util.List;
import java.util.Map;
import management.operations.OperationEvent;
import management.operations.OperationPrms;
import management.operations.events.DLockOperationEvents;
import management.operations.events.impl.AbstractEvents;
import management.util.HydraUtil;

public class DLockEvents
extends AbstractEvents
implements DLockOperationEvents {
    public DLockEvents(Map<String, List<OperationEvent>> eventMap) {
        super(eventMap);
    }

    public DLockEvents() {
    }

    @Override
    public void dlockCreated(String name, DistributedLockService service) {
        if (OperationPrms.recordDlockOperations()) {
            Object[] array;
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_DLOCK_ADDED";
            event.data = array = new Object[]{name, System.currentTimeMillis()};
            this.addEvent(event);
        }
        HydraUtil.logInfo("DLockOperations: Finished with creating DLock : " + name);
    }

    @Override
    public void dlockDestroyed(String name, DistributedLockService service) {
        if (OperationPrms.recordDlockOperations()) {
            Object[] array;
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_DLOCK_DESTROYED";
            event.data = array = new Object[]{name, System.currentTimeMillis()};
            this.addEvent(event);
        }
        HydraUtil.logInfo("DLockOperations: Finished with destroying DLock : " + name);
    }

    @Override
    public void dlockLockUnLock(String name, DistributedLockService service, long l1, long l2, String lockName) {
        if (OperationPrms.recordDlockOperations()) {
            Object[] array;
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_DLOCK_LOCKUNLOCK";
            event.data = array = new Object[]{name, l1, l2, lockName};
            this.addEvent(event);
        }
        HydraUtil.logInfo("DLockOperations: Finished with lockunlocking DLock : " + name);
    }

    @Override
    public void dlockBecomeGrantor(String name, DistributedLockService service) {
        if (OperationPrms.recordDlockOperations()) {
            Object[] array;
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_DLOCK_BECOMEGRANTOR";
            String memberId = InternalDistributedSystem.getConnectedInstance().getDistributedMember().getId();
            event.data = array = new Object[]{name, memberId};
            this.addEvent(event);
        }
        HydraUtil.logInfo("DLockOperations: Finished with lockunlocking DLock : " + name);
    }
}

