/*
 * Decompiled with CFR 0.152.
 */
package management.operations.events.impl;

import java.util.List;
import java.util.Map;
import management.operations.OperationEvent;
import management.operations.OperationPrms;
import management.operations.events.EntryOperationEvents;
import management.operations.events.impl.AbstractEvents;
import management.util.HydraUtil;

public class EntryEvents
extends AbstractEvents
implements EntryOperationEvents {
    public EntryEvents() {
    }

    public EntryEvents(Map<String, List<OperationEvent>> eventMap) {
        super(eventMap);
    }

    @Override
    public void entryAdded(String regionName, String key, Object value) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_ADDED";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with adding entry : " + key);
    }

    @Override
    public void entryInvalidated(String regionName, String key) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_INVALIDATED";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with invalidating entry : " + key);
    }

    @Override
    public void entryDestroyed(String regionName, String key) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_DESTROYED";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with destroying entry : " + key);
    }

    @Override
    public void entryUpdated(String regionName, String key, Object value) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_UPDATED";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with updating entry : " + key);
    }

    @Override
    public void entryRead(String regionName, String key) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_READ";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with reading entry : " + key);
    }

    @Override
    public void entryInvalidatedLocal(String regionName, String key) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_INVALIDATEDLOCAL";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with invalidating locally entry : " + key);
    }

    @Override
    public void entryDestroyedLocal(String regionName, String key) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_DESTROYEDLOCAL";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with destroying locally entry : " + key);
    }

    @Override
    public void entryPutIfAbsent(String regionName, String key, Object value) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_PUTIFABSENT";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with puting IFAbsent entry : " + key);
    }

    @Override
    public void entryRemoved(String regionName, String key) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_REMOVED";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with removing entry : " + key);
    }

    @Override
    public void entryReplaced(String regionName, String key, Object value) {
        if (OperationPrms.recordEntryOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_ENTRY_REPLACED";
            event.data = key;
            this.addEvent(event);
        }
        HydraUtil.logInfo("EntryOperations: region:" + regionName + " Finished with replacing entry : " + key);
    }
}

