/*
 * Decompiled with CFR 0.152.
 */
package management.operations.events.impl;

import java.util.List;
import java.util.Map;
import management.operations.OperationEvent;
import management.operations.OperationPrms;
import management.operations.events.FunctionOperationEvents;
import management.operations.events.impl.AbstractEvents;
import management.util.HydraUtil;

public class FunctionEvents
extends AbstractEvents
implements FunctionOperationEvents {
    public FunctionEvents(Map<String, List<OperationEvent>> eventMap) {
        super(eventMap);
    }

    public FunctionEvents() {
    }

    @Override
    public void functionRegistered(String id) {
        if (OperationPrms.recordFunctionOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_FUNCT_REGISTER";
            event.data = id;
            this.addEvent(event);
        }
        HydraUtil.logInfo("FunctionOperations: Function registration completed for id : " + id);
    }

    @Override
    public void functionUnregistered(String id) {
        if (OperationPrms.recordFunctionOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_FUNCT_UNREGISTER";
            event.data = id;
            this.addEvent(event);
        }
        HydraUtil.logInfo("FunctionOperations: Function un-registration completed for id : " + id);
    }

    @Override
    public void functionExecuted(String id, Object result) {
        if (OperationPrms.recordFunctionOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_FUNCT_EXEC";
            event.data = new Object[]{id, result};
            this.addEvent(event);
        }
        HydraUtil.logInfo("FunctionOperations: Function execution completed for id : " + id);
    }

    public static List<String> getAllRegisteredFunction() {
        List<Object> list = AbstractEvents.getUniqueEventsAcrossAll("EVENT_FUNCT_REGISTER");
        return list;
    }
}

